/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import org.jboss.metatype.api.types.ArrayMetaType;
import org.jboss.metatype.api.types.MetaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetaType<T extends Serializable>
implements MetaType<T> {
    private static final long serialVersionUID = 5786422588217893696L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("className", String.class), new ObjectStreamField("description", String.class), new ObjectStreamField("typeName", String.class)};
    private String className;
    private String description;
    private String typeName;
    private transient boolean array = false;

    protected AbstractMetaType(String className, String typeName, String description) {
        this.init(className, typeName, description);
    }

    protected AbstractMetaType(String className, String description) {
        this.init(className, className, description);
    }

    protected AbstractMetaType(String className) {
        this.init(className, className, className);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public boolean isComposite() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public boolean isTable() {
        return false;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public abstract boolean isValue(Object var1);

    private void init(String className, String typeName, String description) {
        if (className == null || className.trim().equals("")) {
            throw new IllegalArgumentException("null or empty class name");
        }
        if (typeName == null || typeName.trim().equals("")) {
            throw new IllegalArgumentException("null or empty type name");
        }
        if (description == null || description.trim().equals("")) {
            throw new IllegalArgumentException("null or empty description");
        }
        if (!this.isCollection()) {
            String testClassName = AbstractMetaType.getBaseClassName(className);
            if (testClassName == null) {
                throw new IllegalArgumentException("Invalid array declaration (see the javadocs for java.lang.Class): " + className);
            }
            if (!testClassName.equals(className)) {
                this.array = true;
            }
            boolean ok = false;
            for (int i = 0; i < ALLOWED_CLASSNAMES.size(); ++i) {
                if (!testClassName.equals(ALLOWED_CLASSNAMES.get(i))) continue;
                ok = true;
                break;
            }
            if (!ok) {
                int index = className.lastIndexOf(91);
                if (index == className.length() - 2) {
                    ok = ArrayMetaType.isPrimitiveEncoding(className.substring(index + 1));
                }
                if (!ok) {
                    throw new IllegalArgumentException("Not a MetaType allowed class name: " + className);
                }
            }
        }
        this.className = className;
        this.typeName = typeName;
        this.description = description;
    }

    private static String getBaseClassName(String className) {
        int i;
        int length = className.length();
        int last = length - 1;
        for (i = 0; i < length && className.charAt(i) == '['; ++i) {
        }
        if (i > 0) {
            char type = className.charAt(i);
            if (type == 'B' || type == 'C' || type == 'D' || type == 'F' || type == 'I' || type == 'J' || type == 'S' || type == 'Z' || type == 'V') {
                if (i != last) {
                    return null;
                }
                return className.substring(last, length);
            }
            if (className.charAt(i) != 'L' || i >= last - 1 || className.charAt(last) != ';') {
                return null;
            }
            return className.substring(i + 1, last);
        }
        return className;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = in.readFields();
        String className = (String)getField.get("className", null);
        String typeName = (String)getField.get("typeName", null);
        String description = (String)getField.get("description", null);
        try {
            this.init(className, typeName, description);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error deserializing MetaType: " + className, e);
        }
    }
}

