/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.xa.Xid;

public class JBossMQXid
implements Serializable,
Xid {
    private static final long serialVersionUID = -2227021688745286343L;
    private int formatId;
    private byte[] globalTransactionId;
    private byte[] branchQualifier;
    private transient String cachedToString;
    private transient int cachedHashCode;

    public JBossMQXid(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Xid)) {
            return false;
        }
        Xid other = (Xid)object;
        return this.formatId == other.getFormatId() && Arrays.equals(this.globalTransactionId, other.getGlobalTransactionId()) && Arrays.equals(this.branchQualifier, other.getBranchQualifier());
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = this.formatId;
            for (int i = 0; i < this.globalTransactionId.length; ++i) {
                this.cachedHashCode += this.globalTransactionId[i];
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("JBossMQXid[FormatId=").append(this.getFormatId());
            buffer.append(" GlobalId=").append(new String(this.getGlobalTransactionId()).trim());
            byte[] branchQualifer = this.getBranchQualifier();
            buffer.append(" BranchQual=");
            if (branchQualifer == null) {
                buffer.append("null");
            } else {
                buffer.append(new String(this.getBranchQualifier()).trim());
            }
            buffer.append(']');
            this.cachedToString = buffer.toString();
        }
        return this.cachedToString;
    }
}

