/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins.mapping;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import org.jboss.logging.Logger;
import org.jboss.security.config.ApplicationPolicy;
import org.jboss.security.config.MappingInfo;
import org.jboss.security.config.SecurityConfiguration;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.config.MappingModuleEntry;
import org.jboss.security.plugins.JBossSecurityContext;

public class JBossMappingManager
implements MappingManager {
    protected static final Logger log = Logger.getLogger(JBossSecurityContext.class);
    protected boolean trace = log.isTraceEnabled();
    private String securityDomain;

    public JBossMappingManager(String domain) {
        this.securityDomain = domain;
    }

    public MappingContext getMappingContext(Class mappingType) {
        ApplicationPolicy aPolicy = SecurityConfiguration.getApplicationPolicy(this.securityDomain);
        if (aPolicy == null) {
            String defaultDomain = "other";
            if (this.trace) {
                log.trace("Application Policy not found for domain=" + this.securityDomain + ".Mapping framework will use the default domain:" + defaultDomain);
            }
            aPolicy = SecurityConfiguration.getApplicationPolicy(defaultDomain);
        }
        if (aPolicy == null) {
            throw new IllegalStateException("Application Policy is null for the security domain:" + this.securityDomain);
        }
        MappingInfo rmi = null;
        MappingContext mc = null;
        if (mappingType == Group.class) {
            rmi = aPolicy.getRoleMappingInfo();
        } else if (mappingType == Principal.class) {
            rmi = aPolicy.getPrincipalMappingInfo();
        }
        if (rmi != null) {
            MappingModuleEntry[] mpe = rmi.getMappingModuleEntry();
            ArrayList al = new ArrayList();
            for (int i = 0; i < mpe.length; ++i) {
                MappingProvider mp = this.getMappingProvider(mpe[i]);
                if (mp == null) continue;
                al.add(mp);
            }
            mc = new MappingContext(al);
        }
        return mc;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    private MappingProvider getMappingProvider(MappingModuleEntry mme) {
        MappingProvider mp;
        block2: {
            ClassLoader tcl = Thread.currentThread().getContextClassLoader();
            mp = null;
            try {
                Class<?> cl = tcl.loadClass(mme.getMappingModuleName());
                mp = (MappingProvider)cl.newInstance();
                mp.init(mme.getOptions());
            }
            catch (Exception e) {
                if (!this.trace) break block2;
                log.trace("Error in getting Mapping Provider", e);
            }
        }
        return mp;
    }
}

