/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.system.ServiceBinding;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.ServiceCreator;
import org.jboss.system.metadata.ServiceAttributeMetaData;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.system.metadata.ServiceMetaDataParser;
import org.jboss.system.metadata.ServiceValueContext;
import org.jboss.util.xml.DOMWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceConfigurator {
    private final MBeanServer server;
    private final ServiceController serviceController;
    private final ServiceCreator serviceCreator;
    private ServiceBinding serviceBinding;
    private static final Logger log = Logger.getLogger(ServiceConfigurator.class);

    public static void configure(MBeanServer server, ServiceController controller, ObjectName objectName, ObjectName classLoaderName, Collection<ServiceAttributeMetaData> attrs) throws Exception {
        server = ServiceConfigurator.checkMBeanServer(server, controller);
        ClassLoader cl = server.getClassLoader(classLoaderName);
        ServiceConfigurator.configure(server, controller, objectName, cl, attrs);
    }

    public static void configure(MBeanServer server, ServiceController controller, ObjectName objectName, ClassLoader cl, Collection<ServiceAttributeMetaData> attrs) throws Exception {
        ServiceValueContext valueContext = new ServiceValueContext(server, controller, cl);
        server = ServiceConfigurator.checkMBeanServer(server, controller);
        HashMap<String, MBeanAttributeInfo> attributeMap = ServiceConfigurator.getAttributeMap(server, objectName);
        for (ServiceAttributeMetaData attribute : attrs) {
            String attributeName = attribute.getName();
            if (attributeName == null || attributeName.length() == 0) {
                throw new DeploymentException("No or empty attribute name for " + objectName);
            }
            MBeanAttributeInfo attributeInfo = attributeMap.get(attributeName);
            if (attributeInfo == null) {
                throw new DeploymentException("No Attribute found with name: " + attributeName + " for " + objectName + ", attributes: " + attributeMap.keySet());
            }
            valueContext.setAttributeInfo(attributeInfo);
            Object value = attribute.getValue(valueContext);
            try {
                log.debug(attributeName + " set to " + value + " in " + objectName);
                server.setAttribute(objectName, new Attribute(attributeName, value));
            }
            catch (Throwable t) {
                throw new DeploymentException("Exception setting attribute " + attributeName + " on mbean " + objectName, JMXExceptionDecoder.decode(t));
            }
        }
    }

    private static MBeanServer checkMBeanServer(MBeanServer server, ServiceController controller) {
        if (server != null) {
            return server;
        }
        if (controller != null) {
            return controller.getMBeanServer();
        }
        throw new IllegalArgumentException("Either the server or controller must be passed");
    }

    public static void applyServiceConfig(MBeanServer server, ObjectName objectName, ServiceBinding serviceBinding) throws Exception {
        try {
            serviceBinding.applyServiceConfig(objectName);
        }
        catch (Throwable e) {
            Throwable t = JMXExceptionDecoder.decode(e);
            log.warn("Failed to apply service binding override for " + objectName, t);
        }
    }

    private static HashMap<String, MBeanAttributeInfo> getAttributeMap(MBeanServer server, ObjectName objectName) throws Exception {
        MBeanInfo info;
        try {
            info = server.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException e) {
            throw new DeploymentException("Trying to configure nonexistent mbean: " + objectName);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not get mbeanInfo", JMXExceptionDecoder.decode(e));
        }
        if (info == null) {
            throw new DeploymentException("MBeanInfo is null for mbean: " + objectName);
        }
        MBeanAttributeInfo[] attributes = info.getAttributes();
        HashMap<String, MBeanAttributeInfo> attributeMap = new HashMap<String, MBeanAttributeInfo>();
        for (int i = 0; i < attributes.length; ++i) {
            MBeanAttributeInfo attr = attributes[i];
            attributeMap.put(attr.getName(), attr);
        }
        return attributeMap;
    }

    public ServiceConfigurator(MBeanServer server, ServiceController serviceController, ServiceCreator serviceCreator) {
        if (server == null) {
            throw new IllegalArgumentException("Null server");
        }
        if (serviceCreator == null) {
            throw new IllegalArgumentException("Null serverCreator");
        }
        this.server = server;
        this.serviceController = serviceController;
        this.serviceCreator = serviceCreator;
        if (serviceController != null) {
            this.serviceBinding = serviceController.getServiceBinding();
        }
    }

    public void setServiceBinding(ServiceBinding serviceBinding) {
        this.serviceBinding = serviceBinding;
    }

    public List<ObjectName> install(Element config, ObjectName loaderName) throws DeploymentException {
        ServiceMetaDataParser parser = new ServiceMetaDataParser(config);
        List<ServiceMetaData> metaDatas = parser.parse();
        ArrayList<ObjectName> result = new ArrayList<ObjectName>(metaDatas.size());
        for (ServiceMetaData metaData : metaDatas) {
            ObjectName objectName = metaData.getObjectName();
            List<ServiceAttributeMetaData> attrs = metaData.getAttributes();
            try {
                ServiceCreator.install(this.server, objectName, metaData, null);
                result.add(objectName);
                ServiceConfigurator.configure(this.server, null, objectName, loaderName, attrs);
                if (this.serviceBinding == null) continue;
                ServiceConfigurator.applyServiceConfig(this.server, objectName, this.serviceBinding);
            }
            catch (Throwable t) {
                for (ObjectName name : result) {
                    try {
                        this.serviceCreator.remove(name);
                    }
                    catch (Exception e) {
                        log.error("Error removing mbean after failed deployment: " + name, e);
                    }
                }
                DeploymentException.rethrowAsDeploymentException("Error during install", t);
            }
        }
        return result;
    }

    public static String getConfiguration(MBeanServer server, ServiceController serviceController, ObjectName[] objectNames) throws Exception {
        StringWriter out = new StringWriter();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.newDocument();
        Element serverElement = doc.createElement("server");
        for (int j = 0; j < objectNames.length; ++j) {
            Element mbeanElement = ServiceConfigurator.internalGetConfiguration(doc, server, serviceController, objectNames[j]);
            serverElement.appendChild(mbeanElement);
        }
        doc.appendChild(serverElement);
        new DOMWriter(out).setPrettyprint(true).print(doc);
        ((Writer)out).close();
        return ((Object)out).toString();
    }

    private static Element internalGetConfiguration(Document doc, MBeanServer server, ServiceController serviceController, ObjectName name) throws Exception {
        Element mbeanElement = doc.createElement("mbean");
        mbeanElement.setAttribute("name", name.toString());
        MBeanInfo info = server.getMBeanInfo(name);
        mbeanElement.setAttribute("code", info.getClassName());
        MBeanAttributeInfo[] attributes = info.getAttributes();
        boolean trace = log.isTraceEnabled();
        for (int i = 0; i < attributes.length; ++i) {
            if (trace) {
                log.trace("considering attribute: " + attributes[i]);
            }
            if (!attributes[i].isReadable() || !attributes[i].isWritable()) continue;
            Element attributeElement = null;
            if (attributes[i].getType().equals("javax.management.ObjectName")) {
                attributeElement = doc.createElement("depends");
                attributeElement.setAttribute("optional-attribute-name", attributes[i].getName());
            } else {
                attributeElement = doc.createElement("attribute");
                attributeElement.setAttribute("name", attributes[i].getName());
            }
            Object value = server.getAttribute(name, attributes[i].getName());
            if (value != null) {
                if (value instanceof Element) {
                    attributeElement.appendChild(doc.importNode((Element)value, true));
                } else {
                    attributeElement.appendChild(doc.createTextNode(value.toString()));
                }
            }
            mbeanElement.appendChild(attributeElement);
        }
        ServiceContext sc = serviceController.getServiceContext(name);
        for (ServiceContext needs : sc.iDependOn) {
            Element dependsElement = doc.createElement("depends");
            dependsElement.appendChild(doc.createTextNode(needs.objectName.toString()));
            mbeanElement.appendChild(dependsElement);
        }
        return mbeanElement;
    }

    public String getConfiguration(ObjectName[] objectNames) throws Exception {
        return ServiceConfigurator.getConfiguration(this.server, this.serviceController, objectNames);
    }

    public static StringBuffer getElementContent(Element element) throws IOException, TransformerException {
        NodeList children = element.getChildNodes();
        Element content = null;
        for (int n = 0; n < children.getLength(); ++n) {
            Node node = children.item(n);
            if (node.getNodeType() != 1) continue;
            content = (Element)node;
            break;
        }
        if (content == null) {
            return null;
        }
        DOMSource source = new DOMSource(content);
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        sw.close();
        return sw.getBuffer();
    }
}

