/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.metadata;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.annotation.factory.ast.TokenMgrError;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.StringPropertyReplacer;

public class ServiceAnnotationMetaData
extends JBossObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String annotation;
    protected Annotation ann;
    protected boolean replace = true;

    public ServiceAnnotationMetaData() {
    }

    public ServiceAnnotationMetaData(String ann) {
        this.setAnnotation(ann);
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public Annotation getAnnotationInstance() {
        return this.getAnnotationInstance(null);
    }

    public Annotation getAnnotationInstance(ClassLoader cl) {
        try {
            String annString = this.annotation;
            if (this.replace) {
                annString = StringPropertyReplacer.replaceProperties(annString);
            }
            if (cl == null) {
                cl = Thread.currentThread().getContextClassLoader();
            }
            this.ann = (Annotation)AnnotationCreator.createAnnotation(annString, cl);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating annotation for " + this.annotation, e);
        }
        catch (TokenMgrError e) {
            throw new RuntimeException("Error creating annotation for " + this.annotation, e);
        }
        return this.ann;
    }

    public void toString(JBossStringBuilder buffer) {
        buffer.append("expr=").append(this.ann);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.ann);
    }

    protected int getHashCode() {
        return this.annotation.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ServiceAnnotationMetaData)) {
            return false;
        }
        ServiceAnnotationMetaData amd = (ServiceAnnotationMetaData)object;
        return this.replace == amd.replace && this.annotation.equals(amd.annotation);
    }
}

