/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.microcontainer.jmx;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.logging.Logger;
import org.jboss.metadata.spi.MetaData;
import org.jboss.system.ServiceController;

public class ServiceControllerLifecycleCallback {
    private static final Logger log = Logger.getLogger(ServiceControllerLifecycleCallback.class);
    private ServiceController serviceController;

    public ServiceController getServiceController() {
        return this.serviceController;
    }

    public void setServiceController(ServiceController serviceController) {
        this.serviceController = serviceController;
    }

    public void create() throws Exception {
        if (this.serviceController == null) {
            throw new IllegalStateException("No service controller configured");
        }
    }

    public void install(ControllerContext context) throws Exception {
        JMX jmx = this.readJmxAnnotation(context);
        ObjectName objectName = this.createObjectName(context, jmx);
        Class intfClass = null;
        boolean registerDirectly = false;
        if (jmx != null) {
            intfClass = jmx.exposedInterface();
            registerDirectly = jmx.registerDirectly();
        }
        Object mbean = registerDirectly ? context.getTarget() : new StandardMBean(context.getTarget(), intfClass);
        MBeanServer server = this.serviceController.getMBeanServer();
        server.registerMBean(mbean, objectName);
        try {
            this.serviceController.start(objectName);
        }
        catch (Exception e) {
            try {
                server.unregisterMBean(objectName);
            }
            catch (Exception t) {
                log.debug("Error unregistering mbean", t);
            }
            throw e;
        }
        log.debug("Registered MBean " + objectName);
    }

    public void uninstall(ControllerContext context) throws Exception {
        JMX jmx = this.readJmxAnnotation(context);
        ObjectName objectName = this.createObjectName(context, jmx);
        log.debug("Unregistering MBean " + objectName);
        this.serviceController.destroy(objectName);
    }

    private JMX readJmxAnnotation(ControllerContext context) throws Exception {
        MetaData metaData = context.getScopeInfo().getMetaData();
        if (metaData != null) {
            return metaData.getAnnotation(JMX.class);
        }
        return null;
    }

    private ObjectName createObjectName(ControllerContext context, JMX jmx) throws Exception {
        String jmxName;
        ObjectName objectName = null;
        if (jmx != null && (jmxName = jmx.name()) != null && jmxName.length() > 0) {
            objectName = new ObjectName(jmxName);
        }
        if (objectName == null) {
            String name = (String)context.getName();
            objectName = name.contains(":") ? new ObjectName(name) : new ObjectName("test:name='" + name + "'");
        }
        return objectName;
    }
}

