/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.spi.repository.Capability;
import org.jboss.profileservice.spi.repository.Repository;
import org.jboss.profileservice.spi.repository.Requirement;
import org.jboss.profileservice.spi.repository.Resource;
import org.jboss.profileservice.spi.repository.Version;
import org.jboss.system.server.profileservice.repository.CapabilityImpl;

public class VFSDeploymentResource
implements Resource {
    private VFSDeployment deployment;
    private Repository repository;
    private String[] categories = new String[0];
    private Capability[] capabilities;
    private Map<String, Object> props;

    public VFSDeploymentResource(VFSDeployment deployment, ManagedDeployment.DeploymentPhase phase, Repository repository) {
        this.deployment = deployment;
        this.repository = repository;
        CapabilityImpl ci = new CapabilityImpl("deployment");
        ci.addProperty("phase", (Object)phase);
        this.capabilities = new Capability[]{ci};
        this.props = Collections.singletonMap("deployment", deployment);
    }

    public Capability[] getCapabilities() {
        return this.capabilities;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public String getId() {
        return this.deployment.getName();
    }

    public String getPresentationName() {
        return this.deployment.getSimpleName();
    }

    public Map getProperties() {
        return this.props;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Requirement[] getRequirements() {
        return null;
    }

    public String getSymbolicName() {
        return this.deployment.getName();
    }

    public URI getURI() {
        URI uri = null;
        try {
            uri = this.deployment.getRoot().toURI();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return uri;
    }

    public Version getVersion() {
        return null;
    }
}

