/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing.jaxws;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingBuilder;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.jboss.logging.Logger;
import org.jboss.ws.core.CommonMessageContext;
import org.jboss.ws.core.jaxws.handler.GenericSOAPHandler;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.metadata.AddressingOpMetaExt;
import org.jboss.ws.metadata.umdm.OperationMetaData;

public class WSAddressingServerHandler
extends GenericSOAPHandler {
    private static Logger log = Logger.getLogger(WSAddressingServerHandler.class);
    private static AddressingBuilder ADDR_BUILDER;
    private static AddressingConstantsImpl ADDR_CONSTANTS;
    private static Set<QName> HEADERS;

    public Set getHeaders() {
        return Collections.unmodifiableSet(HEADERS);
    }

    protected boolean handleInbound(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("handleInbound");
        }
        SOAPAddressingProperties addrProps = (SOAPAddressingProperties)ADDR_BUILDER.newAddressingProperties();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        addrProps.readHeaders(soapMessage);
        msgContext.put("javax.xml.ws.addressing.context.inbound", addrProps);
        msgContext.setScope("javax.xml.ws.addressing.context.inbound", MessageContext.Scope.APPLICATION);
        return true;
    }

    protected boolean handleOutbound(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("handleOutbound");
        }
        this.handleResponseOrFault(msgContext, false);
        return true;
    }

    public boolean handleFault(MessageContext msgContext) {
        if (log.isDebugEnabled()) {
            log.debug("handleFault");
        }
        this.handleResponseOrFault(msgContext, true);
        return true;
    }

    private void handleResponseOrFault(MessageContext msgContext, boolean isFault) {
        SOAPAddressingBuilder builder = (SOAPAddressingBuilder)SOAPAddressingBuilder.getAddressingBuilder();
        SOAPMessage soapMessage = ((SOAPMessageContext)msgContext).getMessage();
        SOAPAddressingProperties inProps = (SOAPAddressingProperties)msgContext.get("javax.xml.ws.addressing.context.inbound");
        SOAPAddressingProperties outProps = (SOAPAddressingProperties)msgContext.get("javax.xml.ws.addressing.context.outbound");
        if (outProps == null) {
            outProps = (SOAPAddressingProperties)builder.newAddressingProperties();
            msgContext.put("javax.xml.ws.addressing.context.outbound", outProps);
            msgContext.setScope("javax.xml.ws.addressing.context.outbound", MessageContext.Scope.APPLICATION);
        }
        outProps.initializeAsReply(inProps, isFault);
        try {
            OperationMetaData opMetaData = ((CommonMessageContext)((Object)msgContext)).getOperationMetaData();
            if (!isFault && !opMetaData.isOneWay()) {
                AddressingOpMetaExt addrExt = (AddressingOpMetaExt)opMetaData.getExtension(ADDR_CONSTANTS.getNamespaceURI());
                if (addrExt != null) {
                    outProps.setAction(ADDR_BUILDER.newURI(addrExt.getOutboundAction()));
                } else {
                    log.warn("Unable to resolve replyAction for " + opMetaData.getQName());
                }
            } else if (isFault) {
                outProps.setAction(ADDR_BUILDER.newURI(ADDR_CONSTANTS.getDefaultFaultAction()));
            }
        }
        catch (URISyntaxException e) {
            log.error("Error setting response action", e);
        }
        outProps.writeHeaders(soapMessage);
    }

    private void validateRequest(SOAPAddressingProperties addrProps) {
        if (addrProps.getReplyTo() != null && addrProps.getMessageID() == null) {
            throw new IllegalArgumentException("wsa:MessageId is required when wsa:ReplyTo is supplied");
        }
    }

    static {
        HEADERS = new HashSet<QName>();
        ADDR_CONSTANTS = new AddressingConstantsImpl();
        ADDR_BUILDER = AddressingBuilder.getAddressingBuilder();
        HEADERS.add(ADDR_CONSTANTS.getActionQName());
        HEADERS.add(ADDR_CONSTANTS.getToQName());
    }
}

