/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Endpoint;

public class JAXWSMetaDataBuilderJSE {
    private final Logger log = Logger.getLogger(JAXWSMetaDataBuilderJSE.class);

    public UnifiedMetaData buildMetaData(ArchiveDeployment dep) {
        this.log.debug("START buildMetaData: [name=" + dep.getCanonicalName() + "]");
        try {
            UnifiedMetaData wsMetaData = new UnifiedMetaData(dep.getRootFile());
            wsMetaData.setDeploymentName(dep.getCanonicalName());
            ClassLoader runtimeClassLoader = dep.getRuntimeClassLoader();
            if (null == runtimeClassLoader) {
                throw new IllegalArgumentException("Runtime classloader cannot be null");
            }
            wsMetaData.setClassLoader(runtimeClassLoader);
            for (Endpoint ep : dep.getService().getEndpoints()) {
                String shortName = ep.getShortName();
                Class beanClass = ep.getTargetBeanClass();
                JAXWSServerMetaDataBuilder.setupProviderOrWebService(dep, wsMetaData, beanClass, shortName);
            }
            this.log.debug("END buildMetaData: " + wsMetaData);
            return wsMetaData;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            throw new WSException("Cannot build meta data: " + ex.getMessage(), ex);
        }
    }
}

