/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.builder.jaxws;

import java.io.IOException;
import java.net.URL;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.jboss.ws.Constants;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.ws.core.soap.Style;
import org.jboss.ws.metadata.builder.MetaDataBuilder;
import org.jboss.ws.metadata.builder.jaxws.JAXWSServerMetaDataBuilder;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.ws.metadata.umdm.UnifiedMetaData;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.wsf.common.JavaUtils;
import org.jboss.wsf.spi.deployment.ArchiveDeployment;
import org.jboss.wsf.spi.deployment.Endpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXWSProviderMetaDataBuilder
extends JAXWSServerMetaDataBuilder {
    public ServerEndpointMetaData buildProviderMetaData(ArchiveDeployment dep, UnifiedMetaData wsMetaData, Class<?> sepClass, String linkName) throws IOException {
        String portName;
        String targetNS;
        if (!JavaUtils.isAssignableFrom(Provider.class, sepClass)) {
            throw new WebServiceException("Endpoint implementation does not implement javax.xml.ws.Provider: " + sepClass.getName());
        }
        WebServiceProvider anWebServiceProvider = sepClass.getAnnotation(WebServiceProvider.class);
        if (anWebServiceProvider == null) {
            throw new WebServiceException("Cannot obtain @WebServiceProvider annotation from: " + sepClass.getName());
        }
        if (sepClass.isAnnotationPresent(WebService.class)) {
            throw new WebServiceException("Provider cannot carry @WebService annotation: " + sepClass.getName());
        }
        WSDLUtils wsdlUtils = WSDLUtils.getInstance();
        String name = WSDLUtils.getJustClassName(sepClass);
        String serviceName = anWebServiceProvider.serviceName();
        if (serviceName.length() == 0) {
            serviceName = name + "Service";
        }
        if ((targetNS = anWebServiceProvider.targetNamespace()).length() == 0) {
            targetNS = WSDLUtils.getTypeNamespace(sepClass);
        }
        if ((portName = anWebServiceProvider.portName()).length() == 0) {
            portName = name + "Port";
        }
        ServiceMetaData serviceMetaData = new ServiceMetaData(wsMetaData, new QName(targetNS, serviceName));
        wsMetaData.addService(serviceMetaData);
        QName portQName = new QName(targetNS, portName);
        QName portTypeQName = new QName(targetNS, name);
        Endpoint ep = dep.getService().getEndpointByName(linkName);
        ServerEndpointMetaData sepMetaData = new ServerEndpointMetaData(serviceMetaData, ep, portQName, portTypeQName, EndpointMetaData.Type.JAXWS);
        sepMetaData.setLinkName(linkName);
        sepMetaData.setStyle(Style.DOCUMENT);
        sepMetaData.setParameterStyle(SOAPBinding.ParameterStyle.BARE);
        sepMetaData.setServiceEndpointImplName(sepClass.getName());
        sepMetaData.setServiceEndpointInterfaceName(sepClass.getName());
        ServiceMode anServiceMode = sepClass.getAnnotation(ServiceMode.class);
        sepMetaData.setServiceMode(anServiceMode != null ? anServiceMode.value() : Service.Mode.PAYLOAD);
        serviceMetaData.addEndpoint(sepMetaData);
        this.processInvokeMethod(sepMetaData);
        String wsdlLocation = anWebServiceProvider.wsdlLocation();
        if (wsdlLocation.length() > 0) {
            URL wsdlURL = dep.getMetaDataFileURL(wsdlLocation);
            serviceMetaData.setWsdlLocation(wsdlURL);
        }
        this.processBindingType(sepMetaData, sepClass);
        this.processHandlerChain(sepMetaData, sepClass);
        this.processEndpointConfig(dep, sepMetaData, sepClass, linkName);
        this.processWebContext(dep, sepClass, linkName, sepMetaData);
        this.initEndpointAddress(dep, sepMetaData);
        if (sepMetaData.getServiceMetaData().getWsdlLocation() != null) {
            MetaDataBuilder.replaceAddressLocation(sepMetaData);
        }
        ObjectName sepID = MetaDataBuilder.createServiceEndpointID(dep, sepMetaData);
        sepMetaData.setServiceEndpointID(sepID);
        return sepMetaData;
    }

    private void processInvokeMethod(ServerEndpointMetaData epMetaData) {
        String javaName = "invoke";
        String targetNS = epMetaData.getPortName().getNamespaceURI();
        OperationMetaData opMetaData = new OperationMetaData(epMetaData, new QName(targetNS, javaName), javaName);
        epMetaData.addOperation(opMetaData);
        Class<Source> paramType = Source.class;
        QName xmlName = SOAPContentElement.GENERIC_PARAM_NAME;
        QName xmlType = Constants.TYPE_LITERAL_ANYTYPE;
        ParameterMetaData pmd = new ParameterMetaData(opMetaData, xmlName, xmlType, paramType.getName());
        opMetaData.addParameter(pmd);
        xmlName = SOAPContentElement.GENERIC_RETURN_NAME;
        ParameterMetaData retMetaData = new ParameterMetaData(opMetaData, xmlName, xmlType, paramType.getName());
        opMetaData.setReturnParameter(retMetaData);
    }
}

