/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.jaxrpcmapping;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.core.utils.ResourceURL;
import org.jboss.ws.metadata.jaxrpcmapping.ExceptionMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaWsdlMapping;
import org.jboss.ws.metadata.jaxrpcmapping.JavaXmlTypeMapping;
import org.jboss.ws.metadata.jaxrpcmapping.MethodParamPartsMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PackageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.PortMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceEndpointMethodMapping;
import org.jboss.ws.metadata.jaxrpcmapping.ServiceInterfaceMapping;
import org.jboss.ws.metadata.jaxrpcmapping.VariableMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlMessageMapping;
import org.jboss.ws.metadata.jaxrpcmapping.WsdlReturnValueMapping;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.UnmarshallingContext;
import org.xml.sax.Attributes;

public class JavaWsdlMappingFactory
implements ObjectModelFactory {
    private static Logger log = Logger.getLogger(JavaWsdlMappingFactory.class);

    private JavaWsdlMappingFactory() {
    }

    public static JavaWsdlMappingFactory newInstance() {
        return new JavaWsdlMappingFactory();
    }

    public JavaWsdlMapping parse(URL mappingURL) throws IOException {
        if (mappingURL == null) {
            throw new IllegalArgumentException("JAXRPC mapping URL cannot be null");
        }
        InputStream is = new ResourceURL(mappingURL).openStream();
        try {
            JavaWsdlMapping javaWsdlMapping;
            Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
            JavaWsdlMapping javaWsdlMapping2 = javaWsdlMapping = (JavaWsdlMapping)unmarshaller.unmarshal(is, (ObjectModelFactory)this, null);
            return javaWsdlMapping2;
        }
        catch (JBossXBException e) {
            IOException ioex = new IOException("Cannot parse: " + mappingURL);
            Throwable cause = e.getCause();
            if (cause != null) {
                ioex.initCause(cause);
            }
            throw ioex;
        }
        finally {
            is.close();
        }
    }

    public Object newRoot(Object root, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        return new JavaWsdlMapping();
    }

    public Object completeRoot(Object root, UnmarshallingContext ctx, String uri, String name) {
        return root;
    }

    public Object newChild(JavaWsdlMapping javaWsdlMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("package-mapping".equals(localName)) {
            return new PackageMapping(javaWsdlMapping);
        }
        if ("java-xml-type-mapping".equals(localName)) {
            return new JavaXmlTypeMapping(javaWsdlMapping);
        }
        if ("exception-mapping".equals(localName)) {
            return new ExceptionMapping(javaWsdlMapping);
        }
        if ("service-interface-mapping".equals(localName)) {
            return new ServiceInterfaceMapping(javaWsdlMapping);
        }
        if ("service-endpoint-interface-mapping".equals(localName)) {
            return new ServiceEndpointInterfaceMapping(javaWsdlMapping);
        }
        return null;
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, PackageMapping packageMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + packageMapping + "]");
        javaWsdlMapping.addPackageMapping(packageMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, JavaXmlTypeMapping typeMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + typeMapping + "]");
        javaWsdlMapping.addJavaXmlTypeMappings(typeMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, ExceptionMapping exceptionMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + exceptionMapping + "]");
        javaWsdlMapping.addExceptionMappings(exceptionMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, ServiceInterfaceMapping siMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + siMapping + "]");
        javaWsdlMapping.addServiceInterfaceMappings(siMapping);
    }

    public void addChild(JavaWsdlMapping javaWsdlMapping, ServiceEndpointInterfaceMapping seiMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + javaWsdlMapping + ",child=" + seiMapping + "]");
        javaWsdlMapping.addServiceEndpointInterfaceMappings(seiMapping);
    }

    public void setValue(PackageMapping packageMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + packageMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("package-type".equals(localName)) {
            packageMapping.setPackageType(value);
        } else if ("namespaceURI".equals(localName)) {
            packageMapping.setNamespaceURI(value);
        }
    }

    public Object newChild(JavaXmlTypeMapping typeMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("variable-mapping".equals(localName)) {
            return new VariableMapping(typeMapping);
        }
        return null;
    }

    public void addChild(JavaXmlTypeMapping typeMapping, VariableMapping variableMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + typeMapping + ",child=" + variableMapping + "]");
        typeMapping.addVariableMapping(variableMapping);
    }

    public void setValue(JavaXmlTypeMapping typeMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + typeMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("java-type".equals(localName)) {
            typeMapping.setJavaType(value);
        } else if ("root-type-qname".equals(localName)) {
            QName qname = navigator.resolveQName(value);
            typeMapping.setRootTypeQName(qname);
        } else if ("anonymous-type-qname".equals(localName)) {
            int index;
            QName qname = null;
            try {
                qname = navigator.resolveQName(value);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (qname == null && (index = value.lastIndexOf(58)) > 0) {
                String nsURI = value.substring(0, index);
                String localPart = value.substring(index + 1);
                qname = new QName(nsURI, localPart);
            }
            if (qname == null) {
                throw new IllegalArgumentException("Invalid anonymous qname: " + value);
            }
            typeMapping.setAnonymousTypeQName(qname);
        } else if ("qname-scope".equals(localName)) {
            typeMapping.setQNameScope(value);
        }
    }

    public void setValue(ExceptionMapping exceptionMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + exceptionMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("exception-type".equals(localName)) {
            exceptionMapping.setExceptionType(value);
        } else if ("wsdl-message".equals(localName)) {
            exceptionMapping.setWsdlMessage(navigator.resolveQName(value));
        } else if ("constructor-parameter-order".equals(localName)) {
            exceptionMapping.addConstructorParameter(value);
        }
    }

    public Object newChild(ServiceInterfaceMapping siMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("port-mapping".equals(localName)) {
            return new PortMapping(siMapping);
        }
        return null;
    }

    public void addChild(ServiceInterfaceMapping siMapping, PortMapping portMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + siMapping + ",child=" + portMapping + "]");
        siMapping.addPortMapping(portMapping);
    }

    public void setValue(ServiceInterfaceMapping siMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + siMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("service-interface".equals(localName)) {
            siMapping.setServiceInterface(value);
        } else if ("wsdl-service-name".equals(localName)) {
            siMapping.setWsdlServiceName(navigator.resolveQName(value));
        }
    }

    public Object newChild(ServiceEndpointInterfaceMapping seiMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("service-endpoint-method-mapping".equals(localName)) {
            return new ServiceEndpointMethodMapping(seiMapping);
        }
        return null;
    }

    public void addChild(ServiceEndpointInterfaceMapping seiMapping, ServiceEndpointMethodMapping seiMethodMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + seiMapping + ",child=" + seiMapping + "]");
        seiMapping.addServiceEndpointMethodMapping(seiMethodMapping);
    }

    public void setValue(ServiceEndpointInterfaceMapping seiMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + seiMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("service-endpoint-interface".equals(localName)) {
            seiMapping.setServiceEndpointInterface(value);
        } else if ("wsdl-port-type".equals(localName)) {
            seiMapping.setWsdlPortType(navigator.resolveQName(value));
        } else if ("wsdl-binding".equals(localName)) {
            seiMapping.setWsdlBinding(navigator.resolveQName(value));
        }
    }

    public void setValue(VariableMapping variableMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + variableMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("java-variable-name".equals(localName)) {
            variableMapping.setJavaVariableName(value);
        } else if ("data-member".equals(localName)) {
            variableMapping.setDataMember(true);
        } else if ("xml-attribute-name".equals(localName)) {
            variableMapping.setXmlAttributeName(value);
        } else if ("xml-element-name".equals(localName)) {
            variableMapping.setXmlElementName(value);
        }
    }

    public Object newChild(VariableMapping variableMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("data-member".equals(localName)) {
            variableMapping.setDataMember(true);
        } else if ("xml-wildcard".equals(localName)) {
            variableMapping.setXmlWildcard(true);
        }
        return null;
    }

    public void setValue(PortMapping portMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + portMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("port-name".equals(localName)) {
            portMapping.setPortName(value);
        } else if ("java-port-name".equals(localName)) {
            portMapping.setJavaPortName(value);
        }
    }

    public Object newChild(ServiceEndpointMethodMapping methodMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("method-param-parts-mapping".equals(localName)) {
            return new MethodParamPartsMapping(methodMapping);
        }
        if ("wsdl-return-value-mapping".equals(localName)) {
            return new WsdlReturnValueMapping(methodMapping);
        }
        if ("wrapped-element".equals(localName)) {
            methodMapping.setWrappedElement(true);
        }
        return null;
    }

    public void addChild(ServiceEndpointMethodMapping methodMapping, MethodParamPartsMapping partsMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + methodMapping + ",child=" + partsMapping + "]");
        methodMapping.addMethodParamPartsMapping(partsMapping);
    }

    public void addChild(ServiceEndpointMethodMapping methodMapping, WsdlReturnValueMapping returnValueMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + methodMapping + ",child=" + returnValueMapping + "]");
        methodMapping.setWsdlReturnValueMapping(returnValueMapping);
    }

    public void setValue(ServiceEndpointMethodMapping methodMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + methodMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("java-method-name".equals(localName)) {
            methodMapping.setJavaMethodName(value);
        } else if ("wsdl-operation".equals(localName)) {
            methodMapping.setWsdlOperation(value);
        }
    }

    public Object newChild(MethodParamPartsMapping partsMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("wsdl-message-mapping".equals(localName)) {
            return new WsdlMessageMapping(partsMapping);
        }
        return null;
    }

    public void addChild(MethodParamPartsMapping partsMapping, WsdlMessageMapping msgMapping, UnmarshallingContext navigator, String namespaceURI, String localName) {
        log.trace("addChild: [obj=" + partsMapping + ",child=" + msgMapping + "]");
        partsMapping.setWsdlMessageMapping(msgMapping);
    }

    public void setValue(MethodParamPartsMapping partsMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + partsMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("param-position".equals(localName)) {
            partsMapping.setParamPosition(new Integer(value));
        } else if ("param-type".equals(localName)) {
            partsMapping.setParamType(value);
        }
    }

    public void setValue(WsdlReturnValueMapping retValueMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + retValueMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("method-return-value".equals(localName)) {
            retValueMapping.setMethodReturnValue(value);
        } else if ("wsdl-message".equals(localName)) {
            retValueMapping.setWsdlMessage(navigator.resolveQName(value));
        } else if ("wsdl-message-part-name".equals(localName)) {
            retValueMapping.setWsdlMessagePartName(value);
        }
    }

    public void setValue(WsdlMessageMapping msgMapping, UnmarshallingContext navigator, String namespaceURI, String localName, String value) {
        log.trace("setValue: [obj=" + msgMapping + ",localName=" + localName + ",value=" + value + "]");
        if ("wsdl-message".equals(localName)) {
            msgMapping.setWsdlMessage(navigator.resolveQName(value));
        } else if ("wsdl-message-part-name".equals(localName)) {
            msgMapping.setWsdlMessagePartName(value);
        } else if ("parameter-mode".equals(localName)) {
            msgMapping.setParameterMode(value);
        }
    }

    public Object newChild(WsdlMessageMapping msgMapping, UnmarshallingContext navigator, String namespaceURI, String localName, Attributes attrs) {
        log.trace("newChild: " + localName);
        if ("soap-header".equals(localName)) {
            msgMapping.setSoapHeader(true);
        }
        return null;
    }
}

