/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.DynamicWrapperGenerator;
import org.jboss.ws.metadata.acessor.ReflectiveFieldAccessor;
import org.jboss.ws.metadata.acessor.ReflectiveMethodAccessor;
import org.jboss.ws.metadata.umdm.AccessorFactory;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.wsf.common.JavaUtils;

public class FaultMetaData {
    private final Logger log = Logger.getLogger(FaultMetaData.class);
    private OperationMetaData opMetaData;
    private QName xmlName;
    private QName xmlType;
    private String javaTypeName;
    private String faultBeanName;
    private Class javaType;
    private Class faultBean;
    private Method faultInfoMethod;
    private Constructor serviceExceptionConstructor;
    private Method[] serviceExceptionGetters;
    private WrappedParameter[] faultBeanProperties;
    private Class[] propertyTypes;

    public FaultMetaData(OperationMetaData operation, QName xmlName, QName xmlType, String javaTypeName) {
        this(operation, xmlName, javaTypeName);
        this.setXmlType(xmlType);
    }

    public FaultMetaData(OperationMetaData operation, QName xmlName, String javaTypeName) {
        if (xmlName == null) {
            throw new IllegalArgumentException("Invalid null xmlName argument");
        }
        if (javaTypeName == null) {
            throw new IllegalArgumentException("Invalid null javaTypeName argument, for: " + xmlName);
        }
        this.opMetaData = operation;
        this.xmlName = xmlName;
        this.javaTypeName = javaTypeName;
    }

    public OperationMetaData getOperationMetaData() {
        return this.opMetaData;
    }

    public QName getXmlName() {
        return this.xmlName;
    }

    public QName getXmlType() {
        return this.xmlType;
    }

    public void setXmlType(QName xmlType) {
        if (xmlType == null) {
            throw new IllegalArgumentException("Invalid null xmlType argument, for: " + this.xmlName);
        }
        this.xmlType = xmlType;
    }

    public String getJavaTypeName() {
        return this.javaTypeName;
    }

    public Class getJavaType() {
        if (this.javaType != null) {
            return this.javaType;
        }
        if (this.javaTypeName == null) {
            return null;
        }
        try {
            ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
            Class exceptionType = JavaUtils.loadJavaType((String)this.javaTypeName, (ClassLoader)loader);
            if (!Exception.class.isAssignableFrom(exceptionType)) {
                throw new IllegalStateException("Is not assignable to exception: " + exceptionType);
            }
            if (this.opMetaData.getEndpointMetaData().getServiceMetaData().getUnifiedMetaData().isEagerInitialized()) {
                this.log.warn("Loading java type after eager initialization");
                this.javaType = exceptionType;
            }
            return exceptionType;
        }
        catch (ClassNotFoundException ex) {
            throw new WSException("Cannot load java type: " + this.javaTypeName, ex);
        }
    }

    public String getFaultBeanName() {
        return this.faultBeanName;
    }

    public void setFaultBeanName(String faultBeanName) {
        this.faultBeanName = faultBeanName;
    }

    public Class loadFaultBean() {
        Class faultBean = null;
        try {
            ClassLoader loader = this.getOperationMetaData().getEndpointMetaData().getClassLoader();
            faultBean = JavaUtils.loadJavaType((String)this.faultBeanName, (ClassLoader)loader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return faultBean;
    }

    public Class getFaultBean() {
        Class tmpFaultBean = this.faultBean;
        if (tmpFaultBean == null && this.faultBeanName != null) {
            try {
                ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
                tmpFaultBean = JavaUtils.loadJavaType((String)this.faultBeanName, (ClassLoader)loader);
            }
            catch (ClassNotFoundException ex) {
                throw new WSException("Cannot load fault bean: " + this.faultBeanName, ex);
            }
        }
        return tmpFaultBean;
    }

    public void validate() {
    }

    public void eagerInitialize() {
        EndpointMetaData.Type epType = this.getOperationMetaData().getEndpointMetaData().getType();
        if (epType == EndpointMetaData.Type.JAXWS && this.faultBeanName != null && this.loadFaultBean() == null) {
            ClassLoader loader = this.opMetaData.getEndpointMetaData().getClassLoader();
            new DynamicWrapperGenerator(loader).generate(this);
        }
        this.javaType = this.getJavaType();
        if (this.javaType == null) {
            throw new WSException("Cannot load java type: " + this.javaTypeName);
        }
        if (!JavaUtils.isAssignableFrom(Exception.class, (Class)this.javaType)) {
            throw new WSException("Fault java type is not a java.lang.Exception: " + this.javaTypeName);
        }
        if (epType == EndpointMetaData.Type.JAXWS) {
            this.faultBean = this.getFaultBean();
            if (this.faultBean != null) {
                this.initializeFaultBean();
            }
        }
    }

    private void initializeFaultBean() {
        try {
            this.serviceExceptionConstructor = this.javaType.getConstructor(String.class, this.faultBean);
            this.faultInfoMethod = this.javaType.getMethod("getFaultInfo", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            XmlType xmlType = this.faultBean.getAnnotation(XmlType.class);
            if (xmlType == null) {
                throw new WebServiceException("@XmlType missing from fault bean: " + this.faultBeanName);
            }
            AccessorFactory accessorFactory = this.getAccessorFactory(this.faultBean);
            String[] propertyNames = xmlType.propOrder();
            int propertyCount = propertyNames.length;
            this.propertyTypes = new Class[propertyCount];
            this.faultBeanProperties = new WrappedParameter[propertyCount];
            this.serviceExceptionGetters = new Method[propertyCount];
            for (int i = 0; i < propertyCount; ++i) {
                PropertyDescriptor propertyDescriptor;
                String propertyName = propertyNames[i];
                try {
                    propertyDescriptor = new PropertyDescriptor(propertyName, this.faultBean);
                    Class<?> propertyType = propertyDescriptor.getPropertyType();
                    WrappedParameter faultBeanProperty = new WrappedParameter(null, propertyType.getName(), propertyName, i);
                    faultBeanProperty.setAccessor(accessorFactory.create(faultBeanProperty));
                    this.faultBeanProperties[i] = faultBeanProperty;
                    this.propertyTypes[i] = propertyType;
                }
                catch (IntrospectionException ie) {
                    throw new WSException("Property '" + propertyName + "' not found in fault bean '" + this.faultBeanName + "'", ie);
                }
                try {
                    propertyDescriptor = new PropertyDescriptor(propertyName, this.javaType, "is" + JavaUtils.capitalize((String)propertyName), null);
                    this.serviceExceptionGetters[i] = propertyDescriptor.getReadMethod();
                    continue;
                }
                catch (IntrospectionException ie) {
                    throw new WSException("Property '" + propertyName + "' not found in service exception '" + this.javaTypeName, ie);
                }
            }
            try {
                this.serviceExceptionConstructor = this.javaType.asSubclass(Exception.class).getConstructor(this.propertyTypes);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
    }

    private AccessorFactory getAccessorFactory(Class faultBean) {
        XmlAccessorType type = faultBean.getAnnotation(XmlAccessorType.class);
        if (type != null && type.value() == XmlAccessType.FIELD) {
            return ReflectiveFieldAccessor.FACTORY_CREATOR.create(this);
        }
        return ReflectiveMethodAccessor.FACTORY_CREATOR.create(this);
    }

    public Object toFaultBean(Exception serviceException) {
        Object faultBeanInstance;
        block8: {
            try {
                if (this.faultInfoMethod != null) {
                    faultBeanInstance = this.faultInfoMethod.invoke((Object)serviceException, new Object[0]);
                    break block8;
                }
                try {
                    faultBeanInstance = this.faultBean.newInstance();
                }
                catch (InstantiationException e) {
                    throw new WebServiceException("Fault bean class is not instantiable", e);
                }
                for (int i = 0; i < this.serviceExceptionGetters.length; ++i) {
                    Object propertyValue = this.serviceExceptionGetters[i].invoke((Object)serviceException, new Object[0]);
                    WrappedParameter faultBeanProperty = this.faultBeanProperties[i];
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("copying from " + this.javaType.getSimpleName() + '.' + this.serviceExceptionGetters[i].getName() + " to " + this.faultBean.getSimpleName() + '.' + faultBeanProperty.getVariable() + "<->" + faultBeanProperty.getName() + ": " + propertyValue);
                    }
                    faultBeanProperty.accessor().set(faultBeanInstance, propertyValue);
                }
            }
            catch (IllegalAccessException e) {
                throw new WebServiceException(e);
            }
            catch (InvocationTargetException e) {
                throw new WebServiceException(e.getTargetException());
            }
        }
        return faultBeanInstance;
    }

    public Exception toServiceException(Object faultBean, String message) {
        Exception serviceException;
        try {
            if (this.faultInfoMethod != null) {
                serviceException = (Exception)this.serviceExceptionConstructor.newInstance(message, faultBean);
            } else {
                if (this.serviceExceptionConstructor == null) {
                    throw new WSException("Could not instantiate service exception (" + this.javaType.getSimpleName() + "), since neither a faultInfo nor sorted constructor is present: " + Arrays.toString(this.propertyTypes));
                }
                int propertyCount = this.faultBeanProperties.length;
                Object[] propertyValues = new Object[propertyCount];
                for (int i = 0; i < propertyCount; ++i) {
                    propertyValues[i] = this.faultBeanProperties[i].accessor().get(faultBean);
                }
                this.log.debug("constructing " + this.javaType.getSimpleName() + ": " + Arrays.toString(propertyValues));
                serviceException = (Exception)this.serviceExceptionConstructor.newInstance(propertyValues);
            }
        }
        catch (InstantiationException e) {
            throw new WebServiceException("Service exception is not instantiable", e);
        }
        catch (IllegalAccessException e) {
            throw new WebServiceException(e);
        }
        catch (InvocationTargetException e) {
            throw new WebServiceException(e.getTargetException());
        }
        return serviceException;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nFaultMetaData");
        buffer.append("\n xmlName=" + this.xmlName);
        buffer.append("\n xmlType=" + this.xmlType);
        buffer.append("\n javaType=" + this.javaTypeName);
        buffer.append("\n faultBean=" + this.faultBeanName);
        return buffer.toString();
    }
}

