/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.umdm;

import java.util.ArrayList;
import java.util.Collection;
import javax.management.ObjectName;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.HandlerMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ServiceMetaData;
import org.jboss.wsf.spi.binding.BindingCustomization;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerEndpointMetaData
extends EndpointMetaData {
    protected static final Logger log = Logger.getLogger(ServerEndpointMetaData.class);
    public static final String SEPID_DOMAIN = "jboss.ws";
    public static final String SEPID_PROPERTY_CONTEXT = "context";
    public static final String SEPID_PROPERTY_ENDPOINT = "endpoint";
    private Endpoint endpoint;
    private String linkName;
    private String portComponentName;
    private String implName;
    private ObjectName sepID;
    private String contextRoot;
    private String[] virtualHosts;
    private String urlPattern;
    private String transportGuarantee;
    private boolean secureWSDLAccess;

    public ServerEndpointMetaData(ServiceMetaData service, Endpoint endpoint, QName portName, QName portTypeName, EndpointMetaData.Type type) {
        super(service, portName, portTypeName, type);
        this.endpoint = endpoint;
        this.configName = "Standard Endpoint";
        this.configFile = type == EndpointMetaData.Type.JAXRPC ? "META-INF/standard-jaxrpc-endpoint-config.xml" : "META-INF/standard-jaxws-endpoint-config.xml";
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public String getLinkName() {
        return this.linkName;
    }

    public void setLinkName(String linkName) {
        this.linkName = linkName;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public void setPortComponentName(String portComponentName) {
        this.portComponentName = portComponentName;
    }

    public String getServiceEndpointImplName() {
        return this.implName;
    }

    public void setServiceEndpointImplName(String endpointImpl) {
        this.implName = endpointImpl;
    }

    public ObjectName getServiceEndpointID() {
        return this.sepID;
    }

    public void setServiceEndpointID(ObjectName endpointID) {
        this.sepID = endpointID;
    }

    public String[] getVirtualHosts() {
        return this.virtualHosts;
    }

    public void setVirtualHosts(String[] virtualHosts) {
        this.virtualHosts = virtualHosts;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (contextRoot != null && !contextRoot.startsWith("/")) {
            throw new IllegalArgumentException("context root should start with '/'");
        }
        this.contextRoot = contextRoot;
    }

    public String getURLPattern() {
        return this.urlPattern;
    }

    public void setURLPattern(String urlPattern) {
        if (urlPattern != null && !urlPattern.startsWith("/")) {
            throw new IllegalArgumentException("URL pattern should start with '/'");
        }
        this.urlPattern = urlPattern;
    }

    public String getTransportGuarantee() {
        return this.transportGuarantee;
    }

    public void setTransportGuarantee(String transportGuarantee) {
        this.transportGuarantee = transportGuarantee;
    }

    public boolean isSecureWSDLAccess() {
        return this.secureWSDLAccess;
    }

    public void setSecureWSDLAccess(boolean secureWSDLAccess) {
        this.secureWSDLAccess = secureWSDLAccess;
    }

    @Override
    public String getEndpointAddress() {
        return this.endpoint != null ? this.endpoint.getAddress() : null;
    }

    @Override
    public void setEndpointAddress(String endpointAddress) {
        if (this.endpoint == null) {
            throw new IllegalStateException("Endpoint not available");
        }
        this.endpoint.setAddress(endpointAddress);
    }

    @Override
    public Collection<BindingCustomization> getBindingCustomizations() {
        ArrayList<BindingCustomization> list2 = new ArrayList<BindingCustomization>();
        for (Object att : this.endpoint.getAttachments()) {
            if (!(att instanceof BindingCustomization)) continue;
            list2.add((BindingCustomization)att);
        }
        return list2;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("\nServerEndpointMetaData:");
        buffer.append("\n type=").append((Object)this.getType());
        buffer.append("\n qname=").append(this.getPortName());
        buffer.append("\n id=").append(this.getServiceEndpointID().getCanonicalName());
        buffer.append("\n address=").append(this.getEndpointAddress());
        buffer.append("\n binding=").append(this.getBindingId());
        buffer.append("\n linkName=").append(this.getLinkName());
        buffer.append("\n implName=").append(this.getServiceEndpointImplName());
        buffer.append("\n seiName=").append(this.getServiceEndpointInterfaceName());
        buffer.append("\n serviceMode=").append((Object)this.getServiceMode());
        buffer.append("\n portComponentName=").append(this.getPortComponentName());
        buffer.append("\n contextRoot=").append(this.getContextRoot());
        buffer.append("\n urlPattern=").append(this.getURLPattern());
        buffer.append("\n configFile=").append(this.getConfigFile());
        buffer.append("\n configName=").append(this.getConfigName());
        buffer.append("\n authMethod=").append(this.getAuthMethod());
        buffer.append("\n transportGuarantee=").append(this.getTransportGuarantee());
        buffer.append("\n secureWSDLAccess=").append(this.isSecureWSDLAccess());
        buffer.append("\n properties=").append(this.getProperties());
        for (OperationMetaData opMetaData : this.getOperations()) {
            buffer.append("\n").append(opMetaData);
        }
        for (HandlerMetaData hdlMetaData : this.getHandlerMetaData(UnifiedHandlerMetaData.HandlerType.ALL)) {
            buffer.append("\n").append(hdlMetaData);
        }
        return buffer.toString();
    }
}

