/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.plugins.jdk;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jboss.classloader.spi.base.BaseClassLoader;
import org.jboss.classloader.spi.base.BaseClassLoaderDomain;
import org.jboss.classloader.spi.base.BaseClassLoaderPolicy;
import org.jboss.classloader.spi.jdk.JDKChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractJDKChecker
implements JDKChecker {
    private static final Hack hack;
    private static Set<Class<?>> excluded;

    public boolean isExcluded(Class<?> clazz) {
        if (excluded.isEmpty()) {
            return false;
        }
        for (Class<?> exclude : excluded) {
            if (!exclude.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public static Set<Class<?>> getExcluded() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        return excluded;
    }

    @Override
    public boolean isJDKRequest(String name) {
        Class<?> requesting = this.getRequestingClass(hack.getClassContext());
        return this.isJDKRequestingClass(name, requesting);
    }

    protected Class<?> getRequestingClass(Class[] stack) {
        for (Class clazz : stack) {
            if (Hack.class.isAssignableFrom(clazz) || JDKChecker.class.isAssignableFrom(clazz) || BaseClassLoaderDomain.class.isAssignableFrom(clazz) || BaseClassLoaderPolicy.class.isAssignableFrom(clazz) || ClassLoader.class.isAssignableFrom(clazz) || Class.class.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        throw new RuntimeException("Should not be here!");
    }

    protected boolean isJDKRequestingClass(String name, Class<?> requesting) {
        if (this.isExcluded(requesting)) {
            return false;
        }
        ClassLoader cl = requesting.getClassLoader();
        if (cl == null) {
            return true;
        }
        return !(cl instanceof BaseClassLoader);
    }

    static {
        excluded = new CopyOnWriteArraySet();
        hack = AccessController.doPrivileged(new PrivilegedAction<Hack>(){

            @Override
            public Hack run() {
                return new Hack();
            }
        });
    }

    private static class Hack
    extends SecurityManager {
        private Hack() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

