/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.classloading;

import org.jboss.dependency.plugins.AbstractDependencyItem;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.deployers.plugins.classloading.Module;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.structure.spi.classloading.Requirement;
import org.jboss.util.JBossStringBuilder;

public class RequirementDependencyItem
extends AbstractDependencyItem {
    private static final ControllerState CLASSLOADER = new ControllerState(DeploymentStages.CLASSLOADER.getName());
    private Module module;
    private Requirement requirement;

    public RequirementDependencyItem(Module module, Requirement requirement) {
        super(module != null ? module.getName() : null, null, CLASSLOADER, CLASSLOADER);
        if (module == null) {
            throw new IllegalArgumentException("Null module");
        }
        if (requirement == null) {
            throw new IllegalArgumentException("Null requirement");
        }
        this.module = module;
        this.requirement = requirement;
    }

    public boolean resolve(Controller controller) {
        Object iDependOn = this.module.resolve(controller, this.requirement);
        if (iDependOn != null) {
            ControllerContext context = controller.getContext(iDependOn, CLASSLOADER);
            if (context != null) {
                this.setIDependOn(context.getName());
                this.addDependsOnMe(controller, context);
                this.setResolved(true);
            } else {
                this.setResolved(false);
            }
        }
        return this.isResolved();
    }

    public void unresolved() {
        this.setIDependOn(null);
        this.setResolved(false);
    }

    public void toString(JBossStringBuilder buffer) {
        super.toString(buffer);
        buffer.append(" requirement=").append(this.requirement);
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName()).append(" ").append(this.requirement);
    }

    public String toHumanReadableString() {
        return this.requirement.toString();
    }
}

