/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.structure.spi.helpers;

import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.spi.structure.StructureMetaDataFactory;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.StructuralDeployers;
import org.jboss.deployers.structure.spi.StructureBuilder;

public class AbstractStructuralDeployers
implements StructuralDeployers {
    private StructureBuilder structureBuilder;

    public StructureBuilder getStructureBuilder() {
        return this.structureBuilder;
    }

    public void setStructureBuilder(StructureBuilder structureBuilder) {
        this.structureBuilder = structureBuilder;
    }

    public DeploymentContext determineStructure(Deployment deployment) throws DeploymentException {
        StructureBuilder builder = this.getStructureBuilder();
        if (builder == null) {
            throw new IllegalStateException("No structure builder has been configured");
        }
        Attachments attachments = deployment.getPredeterminedManagedObjects();
        StructureMetaData structureMetaData = attachments.getAttachment(StructureMetaData.class);
        if (structureMetaData == null) {
            structureMetaData = StructureMetaDataFactory.createStructureMetaData();
            try {
                this.determineStructure(deployment, structureMetaData);
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (Throwable t) {
                throw DeploymentException.rethrowAsDeploymentException("Exception determining structure: " + deployment, t);
            }
        }
        return this.structureBuilder.populateContext(deployment, structureMetaData);
    }

    protected void determineStructure(Deployment deployment, StructureMetaData structure) throws Exception {
    }
}

