/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public final class ByteArrayBlob
implements Blob {
    private final byte[] mBytes;

    public ByteArrayBlob(byte[] bytes) {
        if (bytes == null) {
            bytes = new byte[]{};
        }
        this.mBytes = bytes;
    }

    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.mBytes);
    }

    public byte[] getBytes(long pos, int length) throws SQLException {
        if (length < 0 || length > this.mBytes.length || pos > (long)this.mBytes.length) {
            return new byte[0];
        }
        if (pos <= 0L) {
            pos = 1L;
        }
        byte[] buffer = new byte[length];
        System.arraycopy(this.mBytes, (int)pos - 1, buffer, 0, length);
        return buffer;
    }

    public long length() throws SQLException {
        return this.mBytes.length;
    }

    public long position(Blob pattern, long start) throws SQLException {
        return this.position(pattern.getBytes(0L, (int)pattern.length()), start);
    }

    public long position(byte[] pattern, long start) throws SQLException {
        int max = this.mBytes.length - pattern.length;
        if (start < 0L) {
            start = 0L;
        } else if (start >= (long)this.mBytes.length) {
            return -1L;
        }
        if (pattern.length == 0) {
            return -1L;
        }
        byte first = pattern[0];
        int i = (int)start;
        while (true) {
            if (i <= max && this.mBytes[i] != first) {
                ++i;
                continue;
            }
            if (i > max) {
                return -1L;
            }
            int j = i + 1;
            int end = j + pattern.length - 1;
            int k = 1;
            boolean cont = true;
            while (cont && j < end) {
                if (this.mBytes[j++] == pattern[k++]) continue;
                ++i;
                cont = false;
            }
            if (cont) break;
        }
        return i;
    }

    public void free() throws SQLException {
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new UnsupportedOperationException("Unimplemented JDK6 method");
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new UnsupportedOperationException("ByteArrayBlob is immutable");
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new UnsupportedOperationException("ByteArrayBlob is immutable");
    }

    public int setBytes(long pos, byte[] bytes, int offset, int length) throws SQLException {
        throw new UnsupportedOperationException("ByteArrayBlob is immutable");
    }

    public void truncate(long length) throws SQLException {
        throw new UnsupportedOperationException("ByteArrayBlob is immutable");
    }
}

