/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.plugins.SecurityContextAssociation;

public class SecurityActions {
    static ClassLoader getContextClassLoader() {
        return TCLAction.UTIL.getContextClassLoader();
    }

    static ClassLoader getContextClassLoader(Thread thread) {
        return TCLAction.UTIL.getContextClassLoader(thread);
    }

    static void setContextClassLoader(ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(loader);
    }

    static void setContextClassLoader(Thread thread, ClassLoader loader) {
        TCLAction.UTIL.setContextClassLoader(thread, loader);
    }

    static String setContextID(String contextID) {
        SetContextID action = new SetContextID(contextID);
        String previousID = (String)AccessController.doPrivileged(action);
        return previousID;
    }

    public static RunAsIdentity peekRunAsIdentity(int depth) {
        PeekRunAsRoleAction action = new PeekRunAsRoleAction(depth);
        RunAsIdentity principal = (RunAsIdentity)AccessController.doPrivileged(action);
        return principal;
    }

    public static Subject getActiveSubject() {
        Subject subject = (Subject)AccessController.doPrivileged(GetSubjectAction.ACTION);
        return subject;
    }

    public static void pushRunAsIdentity(RunAsIdentity runAsIdentity) {
        PushRunAsIdentityAction action = new PushRunAsIdentityAction(runAsIdentity);
        AccessController.doPrivileged(action);
    }

    public static void pushRunAs(final RunAsIdentity runAsIdentity) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                sc.setOutgoingRunAs(runAsIdentity);
                return null;
            }
        });
    }

    public static SecurityContext getSecurityContext() {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return SecurityContextAssociation.getSecurityContext();
            }
        });
    }

    public static RunAsIdentity popRunAsIdentity() {
        return (RunAsIdentity)AccessController.doPrivileged(PopRunAsIdentityAction.ACTION);
    }

    public static RunAsIdentity popRunAs() {
        return (RunAsIdentity)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                SecurityContext sc = SecurityActions.getSecurityContext();
                RunAsIdentity ra = (RunAsIdentity)sc.getOutgoingRunAs();
                sc.setOutgoingRunAs(null);
                return ra;
            }
        });
    }

    public static SecurityContext createSecurityContext(final String securityDomain) throws PrivilegedActionException {
        return (SecurityContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return SecurityContextFactory.createSecurityContext(securityDomain);
            }
        });
    }

    static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }

            public ClassLoader getContextClassLoader(Thread thread) {
                return thread.getContextClassLoader();
            }

            public void setContextClassLoader(ClassLoader cl) {
                Thread.currentThread().setContextClassLoader(cl);
            }

            public void setContextClassLoader(Thread thread, ClassLoader cl) {
                thread.setContextClassLoader(cl);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){
            private final PrivilegedAction getTCLPrivilegedAction = new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            };

            public ClassLoader getContextClassLoader() {
                return (ClassLoader)AccessController.doPrivileged(this.getTCLPrivilegedAction);
            }

            public ClassLoader getContextClassLoader(final Thread thread) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return thread.getContextClassLoader();
                    }
                });
            }

            public void setContextClassLoader(final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Thread.currentThread().setContextClassLoader(cl);
                        return null;
                    }
                });
            }

            public void setContextClassLoader(final Thread thread, final ClassLoader cl) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        thread.setContextClassLoader(cl);
                        return null;
                    }
                });
            }
        };

        public ClassLoader getContextClassLoader();

        public ClassLoader getContextClassLoader(Thread var1);

        public void setContextClassLoader(ClassLoader var1);

        public void setContextClassLoader(Thread var1, ClassLoader var2);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            static ClassLoader getContextClassLoader() {
                return UTIL.getTCLAction().getContextClassLoader();
            }

            static ClassLoader getContextClassLoader(Thread thread) {
                return UTIL.getTCLAction().getContextClassLoader(thread);
            }

            static void setContextClassLoader(ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(cl);
            }

            static void setContextClassLoader(Thread thread, ClassLoader cl) {
                UTIL.getTCLAction().setContextClassLoader(thread, cl);
            }
        }
    }

    private static class PushRunAsIdentityAction
    implements PrivilegedAction {
        RunAsIdentity runAsIdentity;

        PushRunAsIdentityAction(RunAsIdentity runAsIdentity) {
            this.runAsIdentity = runAsIdentity;
        }

        public Object run() {
            SecurityAssociation.pushRunAsIdentity(this.runAsIdentity);
            return null;
        }
    }

    private static class PopRunAsIdentityAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new PopRunAsIdentityAction();

        private PopRunAsIdentityAction() {
        }

        public Object run() {
            return SecurityAssociation.popRunAsIdentity();
        }
    }

    private static class GetSubjectAction
    implements PrivilegedAction {
        static PrivilegedAction ACTION = new GetSubjectAction();

        private GetSubjectAction() {
        }

        public Object run() {
            Subject subject = SecurityAssociation.getSubject();
            return subject;
        }
    }

    private static class PeekRunAsRoleAction
    implements PrivilegedAction {
        int depth;

        PeekRunAsRoleAction(int depth) {
            this.depth = depth;
        }

        public Object run() {
            RunAsIdentity principal = SecurityAssociation.peekRunAsIdentity(this.depth);
            return principal;
        }
    }

    private static class SetContextID
    implements PrivilegedAction {
        String contextID;

        SetContextID(String contextID) {
            this.contextID = contextID;
        }

        public Object run() {
            String previousID = PolicyContext.getContextID();
            PolicyContext.setContextID(this.contextID);
            return previousID;
        }
    }
}

