/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.security.PrivilegedExceptionAction;
import org.jboss.beans.info.plugins.BeanInfoUtil;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.info.spi.PropertyInfo;
import org.jboss.beans.metadata.spi.PropertyMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.kernel.plugins.dependency.ConfigureAction;
import org.jboss.kernel.plugins.dependency.ExecutionWrapper;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyDispatchWrapper
extends ExecutionWrapper {
    private static Logger log = Logger.getLogger(ConfigureAction.class);
    private PropertyMetaData property;
    private boolean nullify;
    private BeanInfo beanInfo;
    private Object target;
    private ClassLoader cl;

    public PropertyDispatchWrapper(PropertyMetaData property, boolean nullify, BeanInfo beanInfo, Object target, ClassLoader cl) {
        if (property == null) {
            throw new IllegalArgumentException("Null property");
        }
        this.property = property;
        this.nullify = nullify;
        if (beanInfo == null) {
            throw new IllegalArgumentException("Null bean info");
        }
        this.beanInfo = beanInfo;
        if (target == null) {
            throw new IllegalArgumentException("Null target");
        }
        this.target = target;
        this.cl = cl;
    }

    @Override
    public Object execute() throws Throwable {
        String name = this.property.getName();
        if (this.nullify) {
            try {
                this.beanInfo.setProperty(this.target, name, null);
            }
            catch (Throwable t) {
                if (log.isTraceEnabled()) {
                    log.trace("Ignored for " + this.target + "." + name, t);
                }
            }
        } else {
            PropertyInfo propertyInfo = BeanInfoUtil.getPropertyInfo(this.beanInfo, this.target, name);
            ValueMetaData valueMetaData = this.property.getValue();
            Object value = valueMetaData.getValue(propertyInfo.getType(), this.cl);
            this.beanInfo.setProperty(this.target, name, value);
        }
        return null;
    }

    @Override
    protected PrivilegedExceptionAction<Object> getAction() {
        return new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                try {
                    return PropertyDispatchWrapper.this.execute();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw e;
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        };
    }
}

