/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Set;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import org.jboss.resource.adapter.jms.JmsConnectionRequestInfo;

public class JmsCred {
    public String name;
    public String pwd;

    public static JmsCred getJmsCred(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws SecurityException {
        JmsCred jc = new JmsCred();
        if (subject == null && info != null) {
            jc.name = ((JmsConnectionRequestInfo)info).getUserName();
            jc.pwd = ((JmsConnectionRequestInfo)info).getPassword();
        } else if (subject != null) {
            PasswordCredential pwdc = GetCredentialAction.getCredential(subject, mcf);
            if (pwdc == null) {
                throw new SecurityException("No Password credentials found");
            }
            jc.name = pwdc.getUserName();
            jc.pwd = new String(pwdc.getPassword());
        } else {
            throw new SecurityException("No Subject or ConnectionRequestInfo set, could not get credentials");
        }
        return jc;
    }

    public String toString() {
        return super.toString() + "{ username=" + this.name + ", password=**** }";
    }

    private static class GetCredentialAction
    implements PrivilegedAction {
        Subject subject;
        ManagedConnectionFactory mcf;

        GetCredentialAction(Subject subject, ManagedConnectionFactory mcf) {
            this.subject = subject;
            this.mcf = mcf;
        }

        public Object run() {
            Set<PasswordCredential> creds = this.subject.getPrivateCredentials(PasswordCredential.class);
            PasswordCredential pwdc = null;
            for (PasswordCredential curCred : creds) {
                if (!((Object)curCred.getManagedConnectionFactory()).equals(this.mcf)) continue;
                pwdc = curCred;
                break;
            }
            return pwdc;
        }

        static PasswordCredential getCredential(Subject subject, ManagedConnectionFactory mcf) {
            GetCredentialAction action = new GetCredentialAction(subject, mcf);
            PasswordCredential pc = (PasswordCredential)AccessController.doPrivileged(action);
            return pc;
        }
    }
}

