/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow.dlq;

import javax.jms.Message;
import javax.naming.Context;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.inflow.dlq.AbstractDLQHandler;

public class JBossMQDLQHandler
extends AbstractDLQHandler {
    protected static final String JMS_JBOSS_REDELIVERY_COUNT = "JMS_JBOSS_REDELIVERY_COUNT";
    protected static final String JMS_JBOSS_REDELIVERY_LIMIT = "JMS_JBOSS_REDELIVERY_LIMIT";
    protected int maxResent;

    public void setup(JmsActivation activation, Context ctx) throws Exception {
        super.setup(activation, ctx);
        this.maxResent = activation.getActivationSpec().getDLQMaxResent();
    }

    protected boolean handleDelivery(Message msg) {
        int max = this.maxResent;
        try {
            int count;
            if (msg.propertyExists(JMS_JBOSS_REDELIVERY_LIMIT)) {
                max = msg.getIntProperty(JMS_JBOSS_REDELIVERY_LIMIT);
            }
            if (msg.propertyExists(JMS_JBOSS_REDELIVERY_COUNT) && (count = msg.getIntProperty(JMS_JBOSS_REDELIVERY_COUNT)) > max) {
                this.warnDLQ(msg, count, max);
                return true;
            }
        }
        catch (Throwable t) {
            log.warn("Unexpected error retrieving message properties " + msg, t);
        }
        return false;
    }
}

