/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import org.jboss.xb.binding.sunday.unmarshalling.XsdBinder;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.DOMLocator;

public class XsdBinderLoggingErrorHandler
implements DOMErrorHandler {
    private static XsdBinderLoggingErrorHandler errorHandler;

    private XsdBinderLoggingErrorHandler() {
    }

    public static XsdBinderLoggingErrorHandler newInstance() {
        if (errorHandler == null) {
            errorHandler = new XsdBinderLoggingErrorHandler();
        }
        return errorHandler;
    }

    public boolean handleError(DOMError error) {
        switch (error.getSeverity()) {
            case 2: {
                XsdBinder.log.error(this.formatMessage(error));
            }
            case 3: {
                XsdBinder.log.fatal(this.formatMessage(error));
            }
            case 1: {
                XsdBinder.log.warn(this.formatMessage(error));
            }
        }
        return false;
    }

    String formatMessage(DOMError error) {
        StringBuffer buf = new StringBuffer();
        DOMLocator location = error.getLocation();
        if (location != null) {
            buf.append(location.getLineNumber()).append(':').append(location.getColumnNumber());
        } else {
            buf.append("[location unavailable]");
        }
        buf.append(' ').append(error.getMessage());
        return buf.toString();
    }
}

