/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jbossatx.jta;

import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionManagerImple;
import com.arjuna.ats.jbossatx.BaseTransactionManagerDelegate;
import com.arjuna.ats.jbossatx.logging.jbossatxLogger;
import java.util.HashMap;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.spi.ObjectFactory;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.tm.TransactionLocal;

public class TransactionManagerDelegate
extends BaseTransactionManagerDelegate
implements ObjectFactory {
    private static final TransactionManagerImple TRANSACTION_MANAGER = new TransactionManagerImple();
    private final String LOCKS_MAP = "__LOCKS_MAP";

    public TransactionManagerDelegate() {
        super(TransactionManagerDelegate.getTransactionManager());
    }

    public int getTransactionTimeout() throws SystemException {
        return TransactionManagerDelegate.getTransactionManager().getTimeout();
    }

    public long getTimeLeftBeforeTransactionTimeout(boolean errorRollback) throws RollbackException {
        try {
            if (this.getStatus() == 1) {
                throw new RollbackException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate.getTimeLeftBeforeTransactionTimeout_1"));
            }
        }
        catch (SystemException se) {
            throw new RollbackException(jbossatxLogger.logMesg.getString("com.arjuna.ats.jbossatx.jta.TransactionManagerDelegate.getTimeLeftBeforeTransactionTimeout_2"));
        }
        return -1L;
    }

    public Object getObjectInstance(Object initObj, Name relativeName, Context namingContext, Hashtable env) throws Exception {
        return this;
    }

    private static TransactionManagerImple getTransactionManager() {
        return TRANSACTION_MANAGER;
    }

    public boolean containsValue(TransactionLocal transactionLocal, Transaction transaction) {
        TransactionImple transactionImple = (TransactionImple)transaction;
        if (transactionImple.isAlive()) {
            return transactionImple.getTxLocalResource(transactionLocal) != null;
        }
        return false;
    }

    public Object getValue(TransactionLocal transactionLocal, Transaction transaction) {
        TransactionImple transactionImple = (TransactionImple)transaction;
        if (transactionImple.isAlive()) {
            return transactionImple.getTxLocalResource(transactionLocal);
        }
        return null;
    }

    public void storeValue(TransactionLocal transactionLocal, Transaction transaction, Object value) {
        TransactionImple transactionImple = (TransactionImple)transaction;
        if (!transactionImple.isAlive()) {
            throw new IllegalStateException("Can't store value in a TransactionLocal after the Transaction has ended");
        }
        transactionImple.putTxLocalResource(transactionLocal, value);
    }

    public void lock(TransactionLocal local, Transaction transaction) throws InterruptedException {
        TransactionLocalLock lock;
        TransactionImple transactionImple = (TransactionImple)transaction;
        if (transactionImple.isAlive() && (lock = this.findLock(local, transaction)).lock(transactionImple)) {
            return;
        }
        throw new IllegalStateException("Can't lock a TransactionLocal after the Transaction has ended");
    }

    public void unlock(TransactionLocal local, Transaction transaction) {
        TransactionLocalLock lock = this.findLock(local, transaction);
        lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransactionLocalLock findLock(TransactionLocal local, Transaction transaction) {
        TransactionImple transactionImple = (TransactionImple)transaction;
        String string = "__LOCKS_MAP";
        synchronized ("__LOCKS_MAP") {
            TransactionLocalLock transactionLocalLock;
            HashMap<TransactionLocal, TransactionLocalLock> locks = (HashMap<TransactionLocal, TransactionLocalLock>)transactionImple.getTxLocalResource("__LOCKS_MAP");
            if (locks == null) {
                locks = new HashMap<TransactionLocal, TransactionLocalLock>();
                transactionImple.putTxLocalResource("__LOCKS_MAP", locks);
            }
            // ** MonitorExit[var5_4] (shouldn't be in output)
            HashMap<TransactionLocal, TransactionLocalLock> hashMap = locks;
            synchronized (hashMap) {
                transactionLocalLock = (TransactionLocalLock)locks.get(local);
                if (transactionLocalLock == null) {
                    transactionLocalLock = new TransactionLocalLock();
                    locks.put(local, transactionLocalLock);
                }
            }
            return transactionLocalLock;
        }
    }

    private class TransactionLocalLock {
        private Thread lockingThread;
        private int lockCount;
        private byte[] lock = new byte[0];

        private TransactionLocalLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean lock(TransactionImple tx) {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                Thread currentThread = Thread.currentThread();
                if (currentThread == this.lockingThread) {
                    ++this.lockCount;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return true;
                }
                while (this.lockingThread != null) {
                    try {
                        long timeout = 0L;
                        try {
                            timeout = TransactionManagerDelegate.this.getTransactionTimeout();
                        }
                        catch (SystemException e) {
                            // empty catch block
                        }
                        this.lock.wait(timeout + 1000L);
                        if (tx.isAlive()) continue;
                        this.lockingThread = null;
                        this.lockCount = 0;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                this.lockingThread = currentThread;
                ++this.lockCount;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock() {
            byte[] byArray = this.lock;
            synchronized (this.lock) {
                if (this.lockCount == 0 && this.lockingThread == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                Thread currentThread = Thread.currentThread();
                if (currentThread != this.lockingThread) {
                    throw new IllegalStateException("Unlock called from wrong thread.  Locking thread: " + this.lockingThread + ", current thread: " + currentThread);
                }
                if (--this.lockCount == 0) {
                    this.lockingThread = null;
                    this.lock.notify();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

