/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.JndiUtil;
import org.jboss.injection.Injector;
import org.jboss.injection.PojoInjector;
import org.jboss.logging.Logger;

public class JndiMethodInjector
implements Injector,
PojoInjector {
    private static final Logger log = Logger.getLogger(JndiMethodInjector.class);
    private Method setMethod;
    private String jndiName;
    private Context ctx;

    public JndiMethodInjector(Method setMethod, String jndiName, Context ctx) {
        this.setMethod = setMethod;
        setMethod.setAccessible(true);
        this.jndiName = jndiName;
        this.ctx = ctx;
    }

    public void inject(BeanContext bctx) {
        this.inject(bctx, bctx.getInstance());
    }

    public Class getInjectionClass() {
        return this.setMethod.getParameterTypes()[0];
    }

    protected Object lookup(String jndiName, Class param) {
        Object dependency = null;
        try {
            dependency = JndiUtil.lookup(this.ctx, jndiName);
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to @Inject jndi dependency: " + jndiName + " into method " + this.setMethod, e);
        }
        return dependency;
    }

    public void inject(BeanContext bctx, Object instance) {
        this.inject(instance);
    }

    public void inject(Object instance) {
        Object dependency = this.lookup(this.jndiName, this.setMethod.getParameterTypes()[0]);
        Object[] args = new Object[]{dependency};
        try {
            this.setMethod.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            String type = "UNKNOWN";
            if (dependency != null) {
                type = dependency.getClass().getName();
            }
            throw new RuntimeException("Non matching type for @Inject of setter: " + this.setMethod + " for type: " + type, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }
}

