/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.FailoverCommandCenter;
import org.jboss.jms.client.FailoverValve2;
import org.jboss.jms.client.FailureDetector;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.exception.MessagingNetworkFailureException;
import org.jboss.logging.Logger;

public class FailoverValveInterceptor
implements Interceptor,
FailureDetector {
    private static final Logger log = Logger.getLogger(FailoverValveInterceptor.class);
    private static boolean trace = log.isTraceEnabled();
    private DelegateSupport delegate;
    private ConnectionState connectionState;

    public String getName() {
        return "FailoverValveInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        FailoverCommandCenter fcc;
        if (this.connectionState == null) {
            HierarchicalState hs;
            this.delegate = (DelegateSupport)invocation.getTargetObject();
            for (hs = this.delegate.getState(); hs != null && !(hs instanceof ConnectionState); hs = hs.getParent()) {
            }
            this.connectionState = (ConnectionState)hs;
        }
        if ((fcc = this.connectionState.getFailoverCommandCenter()) == null) {
            return invocation.invokeNext();
        }
        FailoverValve2 valve = fcc.getValve();
        JMSRemotingConnection remotingConnection = null;
        String methodName = ((MethodInvocation)invocation).getMethod().getName();
        if (methodName.equals("startAfterFailover")) {
            return invocation.invokeNext();
        }
        boolean left = false;
        try {
            valve.enter();
            remotingConnection = fcc.getRemotingConnection();
            Object object = invocation.invokeNext();
            return object;
        }
        catch (MessagingNetworkFailureException e) {
            Object object;
            valve.leave();
            left = true;
            log.debug(this + " detected network failure, putting " + methodName + "() on hold until failover completes");
            fcc.failureDetected(e, this, remotingConnection);
            if (invocation.getTargetObject() instanceof ClientSessionDelegate && methodName.equals("send") || invocation.getTargetObject() instanceof ClientConnectionDelegate && methodName.equals("sendTransaction")) {
                log.trace(this + " caught " + methodName + "() invocation, enabling check for duplicates");
                Object[] arguments = ((MethodInvocation)invocation).getArguments();
                arguments[1] = Boolean.TRUE;
                ((MethodInvocation)invocation).setArguments(arguments);
            }
            if (methodName.equals("cancelDelivery") || methodName.equals("cancelDeliveries")) {
                log.trace(this + " NOT resuming " + methodName + "(), let it wither and die");
                object = null;
                return object;
            }
            log.trace(this + " resuming " + methodName + "()");
            object = invocation.invokeNext();
            return object;
        }
        catch (Throwable e) {
            if (trace) {
                log.trace(this + " caught not failover-triggering throwable, rethrowing " + e);
            }
            throw e;
        }
        finally {
            if (!left) {
                valve.leave();
            }
        }
    }

    public String toString() {
        return "FailoverValveInterceptor." + (this.delegate == null ? "UNITIALIZED" : this.delegate.toString());
    }
}

