/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.impl.postoffice;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import org.jboss.messaging.core.impl.postoffice.ClusterRequest;
import org.jboss.messaging.core.impl.postoffice.RequestTarget;
import org.jboss.messaging.util.StreamUtils;

class RemoveReplicantRequest
extends ClusterRequest {
    private int nodeId;
    private Serializable key;

    RemoveReplicantRequest() {
    }

    RemoveReplicantRequest(int nodeId, Serializable key) {
        this.nodeId = nodeId;
        this.key = key;
    }

    Object execute(RequestTarget office) throws Exception {
        if (!office.removeReplicantLocally(this.nodeId, this.key)) {
            throw new IllegalStateException("Failed to remove replicant locally: " + this.nodeId + " key: " + this.key);
        }
        return null;
    }

    byte getType() {
        return 7;
    }

    public void read(DataInputStream in) throws Exception {
        this.nodeId = in.readInt();
        this.key = (Serializable)StreamUtils.readObject(in, true);
    }

    public void write(DataOutputStream out) throws Exception {
        out.writeInt(this.nodeId);
        StreamUtils.writeObject(out, this.key, true, true);
    }
}

