/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util.prioritylinkedlist;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.prioritylinkedlist.PriorityLinkedList;

public class BasicPriorityLinkedList
implements PriorityLinkedList {
    private static final Logger log = Logger.getLogger(BasicPriorityLinkedList.class);
    protected LinkedList[] linkedLists;
    protected int priorities;
    protected int size;

    public void dump() {
        log.debug("Dumping " + this);
        log.debug("Size:" + this.size);
        log.debug("===============");
        for (int i = 0; i < this.linkedLists.length; ++i) {
            log.debug("Priority:" + i);
            log.debug("----------------");
            Iterator iter = this.linkedLists[i].iterator();
            while (iter.hasNext()) {
                log.debug("Ref: " + iter.next());
            }
        }
    }

    public BasicPriorityLinkedList(int priorities) {
        this.priorities = priorities;
        this.initDeques();
    }

    public void addFirst(Object obj, int priority) {
        this.linkedLists[priority].addFirst(obj);
        ++this.size;
    }

    public void addLast(Object obj, int priority) {
        this.linkedLists[priority].addLast(obj);
        ++this.size;
    }

    public Object removeFirst() {
        Object obj = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            LinkedList ll = this.linkedLists[i];
            if (ll.isEmpty()) continue;
            obj = ll.removeFirst();
            break;
        }
        if (obj != null) {
            --this.size;
        }
        return obj;
    }

    public Object removeLast() {
        Object obj = null;
        for (int i = 0; i < this.priorities; ++i) {
            LinkedList ll = this.linkedLists[i];
            if (!ll.isEmpty()) {
                obj = ll.removeLast();
            }
            if (obj != null) break;
        }
        if (obj != null) {
            --this.size;
        }
        return obj;
    }

    public Object peekFirst() {
        Object obj = null;
        for (int i = this.priorities - 1; i >= 0; --i) {
            LinkedList ll = this.linkedLists[i];
            if (!ll.isEmpty()) {
                obj = ll.getFirst();
            }
            if (obj != null) break;
        }
        return obj;
    }

    public List getAll() {
        ArrayList all = new ArrayList();
        for (int i = this.priorities - 1; i >= 0; --i) {
            LinkedList deque = this.linkedLists[i];
            all.addAll(deque);
        }
        return all;
    }

    public void clear() {
        this.initDeques();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public ListIterator iterator() {
        return new PriorityLinkedListIterator(this.linkedLists);
    }

    protected void initDeques() {
        this.linkedLists = new LinkedList[this.priorities];
        for (int i = 0; i < this.priorities; ++i) {
            this.linkedLists[i] = new LinkedList();
        }
        this.size = 0;
    }

    class PriorityLinkedListIterator
    implements ListIterator {
        private LinkedList[] lists;
        private int index;
        private ListIterator currentIter;

        PriorityLinkedListIterator(LinkedList[] lists) {
            this.lists = lists;
            this.index = lists.length - 1;
            this.currentIter = lists[this.index].listIterator();
        }

        public void add(Object arg0) {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            if (this.currentIter.hasNext()) {
                return true;
            }
            while (this.index >= 0 && this.index != 0 && !this.currentIter.hasNext()) {
                --this.index;
                this.currentIter = this.lists[this.index].listIterator();
            }
            return this.currentIter.hasNext();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.currentIter.next();
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public Object previous() {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            this.currentIter.remove();
            --BasicPriorityLinkedList.this.size;
        }

        public void set(Object obj) {
            throw new UnsupportedOperationException();
        }
    }
}

