/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.container.modules;

import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.callback.SecurityAssociationHandler;
import org.jboss.security.auth.container.modules.DelegatingServerAuthModule;

public class HttpServletServerAuthModule
extends DelegatingServerAuthModule {
    public HttpServletServerAuthModule() {
        this("");
    }

    public HttpServletServerAuthModule(String lmshName) {
        super(lmshName);
        this.supportedTypes.add(HttpServletRequest.class);
        this.supportedTypes.add(HttpServletResponse.class);
    }

    protected boolean validate(Subject clientSubject) throws AuthException {
        this.callbackHandler = new SecurityAssociationHandler(this.getUserName(), this.getCredential());
        return super.validate(clientSubject);
    }

    public AuthStatus secureResponse(MessageInfo arg0, Subject arg1) throws AuthException {
        return null;
    }

    private Principal getUserName() {
        String userNameParam = (String)this.options.get("userNameParam");
        if (!(this.requestInfo instanceof HttpServletRequest)) {
            throw new IllegalStateException("Wrong Form of request:" + this.requestInfo);
        }
        HttpServletRequest hsr = (HttpServletRequest)this.requestInfo;
        return new SimplePrincipal(hsr.getParameter(userNameParam));
    }

    private Object getCredential() {
        String passwordParam = (String)this.options.get("passwordParam");
        if (!(this.requestInfo instanceof HttpServletRequest)) {
            throw new IllegalStateException("Wrong Form of request:" + this.requestInfo);
        }
        HttpServletRequest hsr = (HttpServletRequest)this.requestInfo;
        return hsr.getParameter(passwordParam);
    }
}

