/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding.sunday.unmarshalling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.xb.binding.metadata.AddMethodMetaData;
import org.jboss.xb.binding.metadata.CharactersMetaData;
import org.jboss.xb.binding.metadata.ClassMetaData;
import org.jboss.xb.binding.metadata.MapEntryMetaData;
import org.jboss.xb.binding.metadata.PropertyMetaData;
import org.jboss.xb.binding.metadata.ValueMetaData;
import org.jboss.xb.binding.sunday.marshalling.TermBeforeMarshallingCallback;
import org.jboss.xb.binding.sunday.unmarshalling.AllBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeBinding;
import org.jboss.xb.binding.sunday.unmarshalling.AttributeHandler;
import org.jboss.xb.binding.sunday.unmarshalling.CharactersHandler;
import org.jboss.xb.binding.sunday.unmarshalling.DefaultHandlers;
import org.jboss.xb.binding.sunday.unmarshalling.ElementBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ElementInterceptor;
import org.jboss.xb.binding.sunday.unmarshalling.ModelGroupBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ParticleHandler;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.TermBeforeSetParentCallback;
import org.jboss.xb.binding.sunday.unmarshalling.TermBinding;
import org.jboss.xb.binding.sunday.unmarshalling.ValueAdapter;
import org.jboss.xb.binding.sunday.unmarshalling.WildcardBinding;
import org.jboss.xb.binding.sunday.xop.XOPMarshaller;
import org.jboss.xb.binding.sunday.xop.XOPUnmarshaller;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class TypeBinding {
    protected QName qName;
    private Map attrs = Collections.EMPTY_MAP;
    private ParticleHandler handler;
    private CharactersHandler charactersHandler;
    private ClassMetaData classMetaData;
    private ValueMetaData valueMetaData;
    private PropertyMetaData propertyMetaData;
    private MapEntryMetaData mapEntryMetaData;
    private SchemaBinding schemaBinding;
    private TypeBinding baseType;
    private boolean skip;
    private CharactersMetaData charMetaData;
    private AddMethodMetaData addMethodMetaData;
    private ValueAdapter valueAdapter = ValueAdapter.NOOP;
    private TermBeforeMarshallingCallback beforeMarshallingCallback;
    private TermBeforeSetParentCallback beforeSetParentCallback;
    private Boolean startElementCreatesObject;
    private Boolean simple;
    private WildcardBinding wildcard;
    private ParticleBinding particle;
    private List patternValues;
    private List enumValues;
    private TypeBinding itemType;
    private TypeBinding simpleType;
    private XOPUnmarshaller xopUnmarshaller;
    private XOPMarshaller xopMarshaller;
    private Map interceptors = Collections.EMPTY_MAP;
    private boolean initializedWildcard;

    public TypeBinding() {
        this.qName = null;
    }

    public TypeBinding(QName qName) {
        this(qName, DefaultHandlers.CHARACTERS_HANDLER);
    }

    public TypeBinding(CharactersHandler charactersHandler) {
        this(null, charactersHandler);
    }

    public TypeBinding(QName qName, CharactersHandler charactersHandler) {
        this.qName = qName;
        this.charactersHandler = charactersHandler;
    }

    public TypeBinding(QName qName, TypeBinding baseType) {
        this(qName, baseType.charactersHandler);
        if (baseType.particle != null) {
            this.particle = baseType.particle;
        }
        this.attrs = new HashMap(baseType.attrs);
        this.classMetaData = baseType.classMetaData;
        this.valueMetaData = baseType.valueMetaData;
        this.propertyMetaData = baseType.propertyMetaData;
        this.mapEntryMetaData = baseType.mapEntryMetaData;
        this.schemaBinding = baseType.schemaBinding;
        this.baseType = baseType;
        if (!baseType.isStartElementCreatesObject()) {
            this.handler = baseType.handler;
        }
    }

    public QName getQName() {
        return this.qName;
    }

    public ElementBinding getElement(QName name) {
        return this.getElement(name, true);
    }

    private ElementBinding getElement(QName name, boolean ignoreWildcards) {
        ElementBinding element = null;
        if (this.particle != null) {
            ModelGroupBinding modelGroup = (ModelGroupBinding)this.particle.getTerm();
            element = modelGroup.newCursor(this.particle).getElement(name, null, ignoreWildcards);
        }
        if (element == null && !ignoreWildcards && this.wildcard != null) {
            element = this.wildcard.getElement(name, null);
        }
        return element;
    }

    public void addParticle(ParticleBinding particle) {
        ModelGroupBinding modelGroup;
        if (this.particle == null) {
            modelGroup = new AllBinding(this.schemaBinding);
            this.particle = new ParticleBinding(modelGroup);
        } else {
            modelGroup = (ModelGroupBinding)this.particle.getTerm();
        }
        modelGroup.addParticle(particle);
    }

    public void addElement(ElementBinding element) {
        this.addElement(element, 1, false);
    }

    public void addElement(ElementBinding element, int minOccurs, boolean unbounded) {
        ParticleBinding particle = new ParticleBinding(element);
        particle.setMinOccurs(minOccurs);
        particle.setMaxOccursUnbounded(unbounded);
        this.addParticle(particle);
    }

    public ElementBinding addElement(QName name, TypeBinding type) {
        return this.addElement(name, type, 1, false);
    }

    public ElementBinding addElement(QName name, TypeBinding type, int minOccurs, boolean unbounded) {
        ElementBinding el = new ElementBinding(this.schemaBinding, name, type);
        this.addElement(el, minOccurs, unbounded);
        return el;
    }

    public void addGroup(Map group) {
        for (Map.Entry entry : group.entrySet()) {
            QName name = (QName)entry.getKey();
            TypeBinding type = (TypeBinding)entry.getValue();
            this.addElement(name, type);
        }
    }

    public AttributeBinding getAttribute(QName qName) {
        return (AttributeBinding)this.attrs.get(qName);
    }

    public Attributes expandWithDefaultAttributes(Attributes attrs) {
        if (this.attrs.size() == 0) {
            return attrs;
        }
        HashMap attrsNotSeen = new HashMap(this.attrs);
        for (int n = 0; n < attrs.getLength(); ++n) {
            QName name = new QName(attrs.getURI(n), attrs.getLocalName(n));
            attrsNotSeen.remove(name);
        }
        Attributes expandedAttrs = attrs;
        if (attrsNotSeen.size() > 0) {
            AttributesImpl tmp = new AttributesImpl(attrs);
            for (Map.Entry entry : attrsNotSeen.entrySet()) {
                QName name = (QName)entry.getKey();
                AttributeBinding binding = (AttributeBinding)entry.getValue();
                String constraint = binding.getDefaultConstraint();
                if (constraint == null) continue;
                tmp.addAttribute(name.getNamespaceURI(), name.getLocalPart(), name.toString(), "CDATA", constraint);
            }
            expandedAttrs = tmp;
        }
        return expandedAttrs;
    }

    public AttributeBinding addAttribute(QName name, TypeBinding type, AttributeHandler handler) {
        AttributeBinding attr = new AttributeBinding(this.schemaBinding, name, type, handler);
        this.addAttribute(attr);
        return attr;
    }

    public void addAttribute(AttributeBinding attr) {
        switch (this.attrs.size()) {
            case 0: {
                this.attrs = Collections.singletonMap(attr.getQName(), attr);
                break;
            }
            case 1: {
                this.attrs = new HashMap(this.attrs);
            }
            default: {
                this.attrs.put(attr.getQName(), attr);
            }
        }
    }

    public Collection getAttributes() {
        return this.attrs.values();
    }

    public CharactersHandler getCharactersHandler() {
        return this.charactersHandler;
    }

    public void setCharactersHandler(CharactersHandler charactersHandler) {
        this.charactersHandler = charactersHandler;
    }

    public void setSimpleType(CharactersHandler charactersHandler) {
        this.setSimpleType(new TypeBinding(charactersHandler));
    }

    public TypeBinding getSimpleType() {
        return this.simpleType;
    }

    public void setSimpleType(TypeBinding simpleType) {
        this.simpleType = simpleType;
    }

    public void setHandler(ParticleHandler handler) {
        this.handler = handler;
    }

    public ParticleHandler getHandler() {
        return this.handler;
    }

    public void pushInterceptor(QName qName, ElementInterceptor interceptor) {
        List<ElementInterceptor> intList;
        ElementBinding el = this.getElement(qName);
        if (el == null) {
            el = this.addElement(qName, new TypeBinding());
        }
        if ((intList = (List<ElementInterceptor>)this.interceptors.get(qName)) == null) {
            intList = Collections.singletonList(interceptor);
            switch (this.interceptors.size()) {
                case 0: {
                    this.interceptors = Collections.singletonMap(qName, intList);
                    break;
                }
                case 1: {
                    this.interceptors = new HashMap(this.interceptors);
                }
                default: {
                    this.interceptors.put(qName, intList);
                    break;
                }
            }
        } else {
            if (intList.size() == 1) {
                intList = new ArrayList<ElementInterceptor>(intList);
                this.interceptors.put(qName, intList);
            }
            intList.add(interceptor);
        }
    }

    public List getInterceptors(QName qName) {
        List list2 = (List)this.interceptors.get(qName);
        return list2 == null ? Collections.EMPTY_LIST : list2;
    }

    public TypeBinding getBaseType() {
        return this.baseType;
    }

    public void setBaseType(TypeBinding baseType) {
        this.baseType = baseType;
    }

    public boolean isSimple() {
        return this.simple == null ? this.particle == null && this.attrs.isEmpty() : this.simple;
    }

    public void setSimple(boolean simple) {
        this.simple = simple ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isTextContentAllowed() {
        return this.simpleType != null || this.isSimple();
    }

    public ClassMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public void setClassMetaData(ClassMetaData classMetaData) {
        this.classMetaData = classMetaData;
    }

    public SchemaBinding getSchemaBinding() {
        return this.schemaBinding;
    }

    public void setSchemaBinding(SchemaBinding schemaBinding) {
        this.schemaBinding = schemaBinding;
    }

    public void setValueMetaData(ValueMetaData valueMetaData) {
        this.valueMetaData = valueMetaData;
    }

    public ValueMetaData getValueMetaData() {
        return this.valueMetaData;
    }

    public PropertyMetaData getPropertyMetaData() {
        return this.propertyMetaData;
    }

    public void setPropertyMetaData(PropertyMetaData propertyMetaData) {
        this.propertyMetaData = propertyMetaData;
    }

    public MapEntryMetaData getMapEntryMetaData() {
        return this.mapEntryMetaData;
    }

    public void setMapEntryMetaData(MapEntryMetaData mapEntryMetaData) {
        this.mapEntryMetaData = mapEntryMetaData;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public CharactersMetaData getCharactersMetaData() {
        return this.charMetaData;
    }

    public void setCharactersMetaData(CharactersMetaData charMetaData) {
        this.charMetaData = charMetaData;
    }

    public void setAddMethodMetaData(AddMethodMetaData addMethodMetaData) {
        this.addMethodMetaData = addMethodMetaData;
    }

    public AddMethodMetaData getAddMethodMetaData() {
        return this.addMethodMetaData;
    }

    public ValueAdapter getValueAdapter() {
        return this.valueAdapter;
    }

    public void setValueAdapter(ValueAdapter valueAdapter) {
        this.valueAdapter = valueAdapter;
    }

    public boolean isStartElementCreatesObject() {
        return this.startElementCreatesObject == null ? this.particle != null || !this.attrs.isEmpty() : this.startElementCreatesObject;
    }

    public void setStartElementCreatesObject(boolean startElementCreatesObject) {
        this.startElementCreatesObject = startElementCreatesObject ? Boolean.TRUE : Boolean.FALSE;
    }

    public WildcardBinding getWildcard() {
        if (this.initializedWildcard) {
            return this.wildcard;
        }
        if (this.particle != null) {
            this.wildcard = TypeBinding.getWildcard(this.particle.getTerm());
            this.initializedWildcard = true;
        }
        return this.wildcard;
    }

    public ParticleBinding getParticle() {
        return this.particle;
    }

    public void setParticle(ParticleBinding particle) {
        this.particle = particle;
    }

    public List getLexicalPattern() {
        return this.patternValues;
    }

    public void addLexicalPattern(String patternValue) {
        if (this.patternValues == null) {
            this.patternValues = Collections.singletonList(patternValue);
        } else {
            if (this.patternValues.size() == 1) {
                this.patternValues = new ArrayList(this.patternValues);
            }
            this.patternValues.add(patternValue);
        }
    }

    public List getLexicalEnumeration() {
        return this.enumValues;
    }

    public void addEnumValue(String value) {
        if (this.enumValues == null) {
            this.enumValues = Collections.singletonList(value);
        } else {
            if (this.enumValues.size() == 1) {
                this.enumValues = new ArrayList(this.enumValues);
            }
            this.enumValues.add(value);
        }
    }

    public void setItemType(TypeBinding itemType) {
        this.itemType = itemType;
    }

    public TypeBinding getItemType() {
        return this.itemType;
    }

    public XOPUnmarshaller getXopUnmarshaller() {
        return this.xopUnmarshaller == null ? (this.schemaBinding == null ? null : this.schemaBinding.getXopUnmarshaller()) : this.xopUnmarshaller;
    }

    public void setXopUnmarshaller(XOPUnmarshaller xopUnmarshaller) {
        this.xopUnmarshaller = xopUnmarshaller;
    }

    public XOPMarshaller getXopMarshaller() {
        return this.xopMarshaller == null ? (this.schemaBinding == null ? null : this.schemaBinding.getXopMarshaller()) : this.xopMarshaller;
    }

    public void setXopMarshaller(XOPMarshaller xopMarshaller) {
        this.xopMarshaller = xopMarshaller;
    }

    public boolean hasOnlyXmlMimeAttributes() {
        if (this.attrs.isEmpty()) {
            return false;
        }
        for (QName qName : this.attrs.keySet()) {
            if ("http://www.w3.org/2005/05/xmlmime".equals(qName.getNamespaceURI())) continue;
            return false;
        }
        return true;
    }

    public void setBeforeMarshallingCallback(TermBeforeMarshallingCallback marshallingHandler) {
        this.beforeMarshallingCallback = marshallingHandler;
    }

    public TermBeforeMarshallingCallback getBeforeMarshallingCallback() {
        return this.beforeMarshallingCallback;
    }

    public void setBeforeSetParentCallback(TermBeforeSetParentCallback beforeSetParent) {
        this.beforeSetParentCallback = beforeSetParent;
    }

    public TermBeforeSetParentCallback getBeforeSetParentCallback() {
        return this.beforeSetParentCallback;
    }

    public String toString() {
        return super.toString() + "[" + this.qName + "]";
    }

    private static WildcardBinding getWildcard(TermBinding term) {
        if (term.isWildcard()) {
            return (WildcardBinding)term;
        }
        if (term.isModelGroup()) {
            ModelGroupBinding group = (ModelGroupBinding)term;
            Iterator i = group.getParticles().iterator();
            while (i.hasNext()) {
                WildcardBinding wc;
                term = ((ParticleBinding)i.next()).getTerm();
                if (term.isWildcard()) {
                    return (WildcardBinding)term;
                }
                if (!term.isModelGroup() || (wc = TypeBinding.getWildcard(term)) == null) continue;
                return wc;
            }
        }
        return null;
    }
}

