/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.junit;

import java.lang.reflect.Method;
import java.util.HashSet;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.embedded.Bootstrap;

public class BaseTestCase
extends TestCase {
    private static HashSet flagged = new HashSet();

    public BaseTestCase() {
    }

    public BaseTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (flagged.contains(((Object)((Object)this)).getClass())) {
            return;
        }
        BaseTestCase.bootstrap();
        try {
            Method deploy = ((Object)((Object)this)).getClass().getMethod("deploy", new Class[0]);
            deploy.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (flagged.contains(((Object)((Object)this)).getClass())) {
            return;
        }
        try {
            Method undeploy = ((Object)((Object)this)).getClass().getMethod("undeploy", new Class[0]);
            undeploy.invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (System.getProperty("shutdown.embedded.jboss") != null) {
            Bootstrap.getInstance().shutdown();
        }
    }

    private static void bootstrap() {
        if (Bootstrap.getInstance().isStarted()) {
            return;
        }
        try {
            Bootstrap.getInstance().bootstrap();
        }
        catch (Exception error) {
            throw new RuntimeException("Failed to bootstrap", error);
        }
    }

    public static Test preProcessedTest(final Class testClass) {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(testClass);
        return new TestSetup((Test)suite){

            protected void setUp() throws Exception {
                super.setUp();
                BaseTestCase.bootstrap();
                try {
                    Method deploy = testClass.getMethod("deploy", new Class[0]);
                    deploy.invoke(null, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                flagged.add(testClass);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void tearDown() throws Exception {
                try {
                    Method undeploy = null;
                    try {
                        undeploy = testClass.getMethod("undeploy", new Class[0]);
                        undeploy.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (System.getProperty("shutdown.embedded.jboss") != null) {
                        Bootstrap.getInstance().shutdown();
                    }
                    super.tearDown();
                }
                finally {
                    flagged.remove(testClass);
                }
            }
        };
    }
}

