/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import org.jboss.kernel.spi.deployment.KernelDeployment;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

public class BeanCompiler {
    public static void main(String[] args) throws Exception {
        for (String arg : args) {
            BeanCompiler.compile(arg);
        }
    }

    public static void compile(String arg) throws Exception {
        System.out.println("compiling: " + arg);
        File fp = new File(arg);
        KernelDeployment deployment = BeanCompiler.parse(fp);
        long start = System.currentTimeMillis();
        FileOutputStream fos = new FileOutputStream(arg + ".bin");
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeObject(deployment);
        oos.close();
        fos.close();
        FileInputStream fis = new FileInputStream(arg + ".bin");
        ObjectInputStream ois = new ObjectInputStream(fis);
        deployment = (KernelDeployment)ois.readObject();
        ois.close();
        fis.close();
        long end = System.currentTimeMillis() - start;
        System.out.println("object loading took: " + end);
    }

    public static KernelDeployment parse(File fp) throws JBossXBException, MalformedURLException {
        long start = System.currentTimeMillis();
        SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();
        UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        KernelDeployment deployment = (KernelDeployment)unmarshaller.unmarshal(fp.toURL().toString(), resolver);
        long end = System.currentTimeMillis() - start;
        System.out.println("XML parsing took: " + end);
        return deployment;
    }
}

