/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.example.messages;

import java.io.Serializable;
import java.util.List;
import javax.ejb.Remove;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.example.messages.Message;
import org.jboss.seam.example.messages.MessageManager;

@Stateful
@Scope(value=ScopeType.SESSION)
@Name(value="messageManager")
public class MessageManagerBean
implements Serializable,
MessageManager {
    @DataModel
    private List<Message> messageList;
    @DataModelSelection
    @Out(required=false)
    private Message message;
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    private EntityManager em;

    @Factory(value="messageList")
    public void findMessages() {
        this.messageList = this.em.createQuery("select msg from Message msg order by msg.datetime desc").getResultList();
    }

    public void select() {
        if (this.message != null) {
            this.message.setRead(true);
        }
    }

    public void delete() {
        if (this.message != null) {
            this.messageList.remove(this.message);
            this.em.remove((Object)this.message);
            this.message = null;
        }
    }

    @Remove
    @Destroy
    public void destroy() {
    }
}

