/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.context;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import org.jboss.logging.Logger;
import org.jboss.seam.solder.reflection.AnnotationInstanceProvider;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;

public class FacesAnnotationsAdapterExtension
implements Extension {
    private final transient Logger logger = Logger.getLogger((String)FacesAnnotationsAdapterExtension.class.getName());
    private final Map<Class<? extends Annotation>, Class<? extends Annotation>> scopeAliasMapping = new HashMap<Class<? extends Annotation>, Class<? extends Annotation>>(3);
    private static final Map<Class<?>, Class<? extends Annotation>> aliasedBeans = new HashMap();

    public static Map<Class<?>, Class<? extends Annotation>> getAliasedbeans() {
        return aliasedBeans;
    }

    public FacesAnnotationsAdapterExtension() {
        this.scopeAliasMapping.put(RequestScoped.class, javax.enterprise.context.RequestScoped.class);
        this.scopeAliasMapping.put(javax.faces.bean.SessionScoped.class, SessionScoped.class);
        this.scopeAliasMapping.put(javax.faces.bean.ApplicationScoped.class, ApplicationScoped.class);
    }

    public void aliasJsfScopeIfDetected(@Observes ProcessAnnotatedType<Object> annotatedType) {
        for (Class<? extends Annotation> scope : this.scopeAliasMapping.keySet()) {
            if (!annotatedType.getAnnotatedType().isAnnotationPresent(scope)) continue;
            this.logger.warnf("WARNING: Please annotate class %s with @%s instead of @%s", (Object)annotatedType.getAnnotatedType().getJavaClass(), (Object)this.scopeAliasMapping.get(scope).getName(), (Object)scope.getName());
            aliasedBeans.put(annotatedType.getAnnotatedType().getJavaClass(), scope);
            annotatedType.setAnnotatedType(this.decorateType((AnnotatedType<Object>)annotatedType.getAnnotatedType(), scope));
            break;
        }
    }

    public void failIfJsfManagedBeanAnnotationPresent(@Observes ProcessBean<?> bean) {
        if (bean.getAnnotated().isAnnotationPresent(ManagedBean.class)) {
            bean.addDefinitionError((Throwable)new RuntimeException("Use of @javax.faces.bean.ManagedBean is forbidden. Please use @javax.inject.Named instead."));
        }
    }

    private Class<? extends Annotation> getCdiScopeFor(Class<? extends Annotation> jsfScope) {
        return this.scopeAliasMapping.get(jsfScope);
    }

    private AnnotatedType<Object> decorateType(AnnotatedType<Object> type, Class<? extends Annotation> jsfScope) {
        Class<? extends Annotation> cdiScope = this.getCdiScopeFor(jsfScope);
        AnnotationInstanceProvider provider = new AnnotationInstanceProvider();
        Annotation cdiScopeAnnotation = provider.get(cdiScope, Collections.EMPTY_MAP);
        AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(type).removeFromClass(jsfScope).addToClass(cdiScopeAnnotation);
        return builder.create();
    }
}

