/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.context;

import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.faces.bean.ViewScoped;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PreDestroyViewMapEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;

public class ViewScopedContext
implements Context,
SystemEventListener {
    private static final String COMPONENT_MAP_NAME = "org.jboss.seam.faces.viewscope.componentInstanceMap";
    private static final String CREATIONAL_MAP_NAME = "org.jboss.seam.faces.viewscope.creationalInstanceMap";
    private boolean isJsfSubscribed = false;

    public <T> T get(Contextual<T> component) {
        this.assertActive();
        if (!this.isJsfSubscribed) {
            FacesContext.getCurrentInstance().getApplication().subscribeToEvent(PreDestroyViewMapEvent.class, (SystemEventListener)this);
            this.isJsfSubscribed = true;
        }
        Object instance = this.getComponentInstanceMap().get(component);
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        this.assertActive();
        Object instance = this.get(component);
        if (instance == null && creationalContext != null) {
            Map<Contextual<?>, Object> componentInstanceMap = this.getComponentInstanceMap();
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalInstanceMap();
            Map<Contextual<?>, Object> map = componentInstanceMap;
            synchronized (map) {
                instance = componentInstanceMap.get(component);
                if (instance == null && (instance = component.create(creationalContext)) != null) {
                    componentInstanceMap.put(component, instance);
                    creationalContextMap.put(component, creationalContext);
                }
            }
        }
        return instance;
    }

    public Class<? extends Annotation> getScope() {
        return ViewScoped.class;
    }

    public boolean isActive() {
        return this.getViewRoot() != null;
    }

    private void assertActive() {
        if (!this.isActive()) {
            throw new ContextNotActiveException("Seam context with scope annotation @ViewScoped is not active with respect to the current thread");
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        if (event instanceof PreDestroyViewMapEvent) {
            Map<Contextual<?>, Object> componentInstanceMap = this.getComponentInstanceMap();
            Map<Contextual<?>, CreationalContext<?>> creationalContextMap = this.getCreationalInstanceMap();
            if (componentInstanceMap != null) {
                for (Map.Entry<Contextual<?>, Object> componentEntry : componentInstanceMap.entrySet()) {
                    Contextual<?> contextual = componentEntry.getKey();
                    Object instance = componentEntry.getValue();
                    CreationalContext<?> creational = creationalContextMap.get(contextual);
                    contextual.destroy(instance, creational);
                }
            }
        }
    }

    protected UIViewRoot getViewRoot() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return context.getViewRoot();
        }
        return null;
    }

    protected Map<String, Object> getViewMap() {
        UIViewRoot viewRoot = this.getViewRoot();
        if (viewRoot != null) {
            return viewRoot.getViewMap(true);
        }
        return null;
    }

    private Map<Contextual<?>, Object> getComponentInstanceMap() {
        Map<String, Object> viewMap = this.getViewMap();
        ConcurrentHashMap map = (ConcurrentHashMap)viewMap.get(COMPONENT_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            viewMap.put(COMPONENT_MAP_NAME, map);
        }
        return map;
    }

    private Map<Contextual<?>, CreationalContext<?>> getCreationalInstanceMap() {
        Map<String, Object> viewMap = this.getViewMap();
        ConcurrentHashMap map = (ConcurrentHashMap)viewMap.get(CREATIONAL_MAP_NAME);
        if (map == null) {
            map = new ConcurrentHashMap();
            viewMap.put(CREATIONAL_MAP_NAME, map);
        }
        return map;
    }
}

