/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.view;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewMetadata;
import org.jboss.seam.logging.Logger;

public class SeamViewMetadata
extends ViewMetadata {
    private final transient Logger logger = Logger.getLogger((String)SeamViewMetadata.class.getName());
    private ViewMetadata delegate;

    public SeamViewMetadata(ViewMetadata delegate) {
        this.delegate = delegate;
    }

    public String getViewId() {
        return this.delegate.getViewId();
    }

    public UIViewRoot createMetadataView(FacesContext context) {
        UIViewRoot viewRoot = null;
        try {
            viewRoot = this.delegate.createMetadataView(context);
        }
        catch (RuntimeException e) {
            this.logger.fatal((Object)e.getMessage());
            throw e;
        }
        UIComponent metadataFacet = viewRoot.getFacet("javax_faces_metadata");
        if (metadataFacet == null) {
            return viewRoot;
        }
        boolean foundViewParam = false;
        boolean foundOther = false;
        for (UIComponent candidate : metadataFacet.getChildren()) {
            if (candidate instanceof UIViewParameter) {
                foundViewParam = true;
                continue;
            }
            foundOther = true;
        }
        if (foundOther && !foundViewParam) {
            UIViewParameter placeholder = (UIViewParameter)context.getApplication().createComponent("javax.faces.ViewParameter");
            placeholder.setId(viewRoot.createUniqueId());
            placeholder.setName("");
            metadataFacet.getChildren().add(0, placeholder);
        }
        return viewRoot;
    }
}

