/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.component;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import org.jboss.seam.faces.component.UIValidateForm;
import org.jboss.seam.faces.event.qualifier.After;
import org.jboss.seam.faces.event.qualifier.Before;
import org.jboss.seam.faces.validation.InputElement;
import org.jboss.seam.faces.validation.InputField;
import org.jboss.solder.logging.Logger;

@RequestScoped
public class FormValidationFieldProducer {
    Logger log = Logger.getLogger(FormValidationFieldProducer.class);
    @Inject
    FacesContext context;
    UIForm form = null;
    UIValidateForm validator = null;
    private Map<String, UIInput> components;

    public void interceptComponentTree(@Observes @Before UIValidateForm event) {
        this.validator = event;
        this.form = this.validator.locateForm();
        this.locateAliasedComponents(event);
        event.setComponents(this.components);
    }

    public void cleanupComponentTree(@Observes @After UIValidateForm event) {
        this.components = new HashMap<String, UIInput>();
    }

    @Produces
    @Dependent
    @InputField
    public Object getInputFieldValue(InjectionPoint ip) {
        Object result = null;
        if (this.isInitialized()) {
            Converter converter;
            String id = this.getFieldId(ip);
            UIInput component = this.findComponent(id, id);
            this.components.put(id, component);
            result = component.isLocalValueSet() ? component.getValue() : ((converter = component.getConverter()) != null ? converter.getAsObject(this.context, (UIComponent)component, (String)component.getSubmittedValue()) : component.getSubmittedValue());
        }
        return result;
    }

    @Produces
    @Dependent
    public InputElement produceInputElement(InjectionPoint ip) {
        if (this.isInitialized()) {
            String id = ip.getMember().getName();
            UIInput component = this.findComponent(id, id);
            this.components.put(id, component);
            InputElement inputElementResult = new InputElement(id, component.getClientId(this.context), component);
            if (component.isLocalValueSet()) {
                inputElementResult.setValue(component.getValue());
            } else {
                Converter converter = component.getConverter();
                if (converter != null) {
                    Object value = converter.getAsObject(this.context, (UIComponent)component, (String)component.getSubmittedValue());
                    inputElementResult.setValue(value);
                } else {
                    inputElementResult.setValue(component.getSubmittedValue());
                }
            }
            return inputElementResult;
        }
        return null;
    }

    private boolean isInitialized() {
        return this.form != null;
    }

    private String getFieldId(InjectionPoint ip) {
        String parameterName = ((InputField)ip.getAnnotated().getAnnotation(InputField.class)).value();
        if ("".equals(parameterName)) {
            parameterName = ip.getMember().getName();
        }
        return parameterName;
    }

    public void locateAliasedComponents(UIValidateForm validator) {
        this.components = new HashMap<String, UIInput>();
        String fields = validator.getFields();
        if (fields != null && !"".equals(fields.trim())) {
            List<String> clientFieldIds = Arrays.asList(fields.split("\\s+"));
            for (String field : clientFieldIds) {
                String aliasFieldName;
                List<String> mapping = Arrays.asList(field.split("\\s*=\\s*"));
                String clientInputId = aliasFieldName = mapping.get(0);
                if (mapping.size() > 1) {
                    clientInputId = mapping.get(1);
                }
                UIInput component = this.findComponent(aliasFieldName, clientInputId);
                this.components.put(aliasFieldName, component);
            }
        }
    }

    private UIInput findComponent(String alias, String clientId) {
        UIComponent comp = null;
        if (!this.components.containsKey(clientId)) {
            comp = this.form.findComponent(clientId);
            if (comp == null) {
                throw new IllegalArgumentException("org.jboss.seam.component.UIValidateForm-- Could not locate component [" + this.form.getClientId() + ":" + alias + "]");
            }
            if (!(comp instanceof UIInput)) {
                throw new IllegalArgumentException("org.jboss.seam.component.UIValidateForm-- Selected component [" + this.form.getClientId() + ":" + alias + "] must be a UIInput component, was [" + comp.getClass().getName() + "]");
            }
        } else {
            comp = (UIComponent)this.components.get(clientId);
        }
        return (UIInput)comp;
    }
}

