/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.component;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.seam.faces.validation.InputField;
import org.jboss.solder.reflection.annotated.AnnotatedTypeBuilder;

@ApplicationScoped
public class FormValidationTypeOverrideExtension
implements Extension {
    private final Map<Class<?>, AnnotatedType<?>> typeOverrides = new HashMap();

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder();
        builder.readFromType(event.getAnnotatedType());
        boolean modifiedType = false;
        for (AnnotatedField f : event.getAnnotatedType().getFields()) {
            if (!f.isAnnotationPresent(InputField.class)) continue;
            builder.overrideFieldType(f.getJavaMember(), Object.class);
            modifiedType = true;
        }
        if (modifiedType) {
            AnnotatedType replacement = builder.create();
            this.typeOverrides.put(replacement.getJavaClass(), replacement);
            event.setAnnotatedType(replacement);
        }
    }

    public boolean hasOverriddenType(Class<?> clazz) {
        return this.typeOverrides.containsKey(clazz);
    }

    public AnnotatedType<?> getOverriddenType(Class<?> clazz) {
        return this.typeOverrides.get(clazz);
    }
}

