/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.component;

import java.lang.annotation.Annotation;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import org.jboss.solder.literal.RequestScopedLiteral;
import org.jboss.solder.logging.internal.Logger;
import org.jboss.solder.reflection.annotated.AnnotatedTypeBuilder;

public class ValidatorConverterScopeOverrideExtension
implements Extension {
    private Logger log = Logger.getLogger(ValidatorConverterScopeOverrideExtension.class);

    public <T> void processManagedBean(@Observes ProcessManagedBean<T> event) {
        if (this.isMatch(event.getBean())) {
            this.log.warn((Object)("The " + (event.getBean().getTypes().contains(Validator.class) ? "validator" : "converter") + " bean [" + event.getBean().getBeanClass().getName() + "] does not have a normal scope - overriding it with @RequestScoped"));
            AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(event.getAnnotatedBeanClass());
            builder.removeFromClass(event.getBean().getScope());
            builder.addToClass((Annotation)new RequestScopedLiteral());
        }
    }

    private <T> boolean isMatch(Bean<T> bean) {
        return (bean.getTypes().contains(Validator.class) || bean.getTypes().contains(Converter.class)) && !bean.getScope().isAnnotationPresent(NormalScope.class);
    }
}

