/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.conversion;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.inject.Inject;
import org.jboss.solder.logging.Logger;

@ConversationScoped
@FacesConverter(value="org.jboss.seam.faces.conversion.ObjectConverter")
public class ObjectConverter
implements Converter,
Serializable {
    private static final long serialVersionUID = -406332789399557968L;
    private final Map<String, Object> converterMap = new HashMap<String, Object>();
    private final Map<Object, String> reverseConverterMap = new HashMap<Object, String>();
    @Inject
    private transient Conversation conversation;
    private final transient Logger log = Logger.getLogger(ObjectConverter.class);
    private int incrementor = 1;

    public Object getAsObject(FacesContext context, UIComponent component, String value) {
        if (this.conversation.isTransient()) {
            this.log.warn((Object)"Conversion attempted without a long running conversation");
        }
        return this.converterMap.get(value);
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) {
        if (this.conversation.isTransient()) {
            this.log.warn((Object)"Conversion attempted without a long running conversation");
        }
        if (this.reverseConverterMap.containsKey(value)) {
            return this.reverseConverterMap.get(value);
        }
        String incrementorStringValue = String.valueOf(this.incrementor++);
        this.converterMap.put(incrementorStringValue, value);
        this.reverseConverterMap.put(value, incrementorStringValue);
        return incrementorStringValue;
    }
}

