/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.exception;

import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Iterator;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.FacesException;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.event.ExceptionQueuedEvent;
import org.jboss.seam.faces.qualifier.FacesLiteral;
import org.jboss.solder.core.Requires;
import org.jboss.solder.exception.control.ExceptionToCatch;
import org.jboss.solder.logging.Logger;

@Requires(value={"org.jboss.solder.exception.control.extension.CatchExtension"})
public class CatchExceptionHandler
extends ExceptionHandlerWrapper {
    private final transient Logger log = Logger.getLogger(CatchExceptionHandler.class);
    private ExceptionHandler wrapped;
    private BeanManager beanManager;

    public CatchExceptionHandler() {
    }

    public CatchExceptionHandler(ExceptionHandler wrapped, BeanManager beanManager) {
        this.wrapped = wrapped;
        this.beanManager = beanManager;
    }

    public ExceptionHandler getWrapped() {
        return this.wrapped;
    }

    public void handle() throws FacesException {
        this.log.trace((Object)"Handling Exceptions");
        Iterator it = this.getUnhandledExceptionQueuedEvents().iterator();
        while (it.hasNext()) {
            Throwable t = ((ExceptionQueuedEvent)it.next()).getContext().getException();
            this.log.trace((Object)MessageFormat.format("Handling Exception {0}", t.getClass().getName()));
            ExceptionToCatch catchEvent = new ExceptionToCatch(t, new Annotation[]{FacesLiteral.INSTANCE});
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"Firing event");
                }
                this.beanManager.fireEvent((Object)catchEvent, new Annotation[0]);
            }
            catch (Exception e) {
                if (e.equals(t)) continue;
                this.log.debug((Object)"Throwing exception thrown from within Seam Catch");
                throw new RuntimeException(e);
            }
            if (!catchEvent.isHandled()) continue;
            this.log.debug((Object)MessageFormat.format("Exception handled {0}", t.getClass().getName()));
            it.remove();
        }
        if (this.getUnhandledExceptionQueuedEvents().iterator().hasNext()) {
            this.log.debug((Object)"Exceptions remain, will be thrown outside of JSF");
            this.getWrapped().handle();
        }
    }
}

