/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.projectstage;

import java.net.MalformedURLException;
import java.net.URL;
import org.jboss.seam.faces.projectstage.WebXmlLocator;
import org.jboss.solder.logging.Logger;

public class DirectoryNameWebXmlLocator
implements WebXmlLocator {
    private final Logger log = Logger.getLogger(DirectoryNameWebXmlLocator.class);

    public int getPrecedence() {
        return 50;
    }

    public URL getWebXmlLocation(ClassLoader classLoader) {
        block8: {
            String relativeResourceName = this.getClass().getName().replace('.', '/') + ".class";
            URL knownResource = classLoader.getResource(relativeResourceName);
            if (knownResource == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Could not find resource: " + relativeResourceName));
                }
                return null;
            }
            String url = knownResource.toString();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Found known resource: " + url));
            }
            if (url.startsWith("jar:") && url.contains("!")) {
                url = url.substring(4, url.lastIndexOf("!"));
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Location of JAR file containing the resource: " + url));
                }
            }
            try {
                int i = url.lastIndexOf("/WEB-INF/lib/");
                if (i >= 0) {
                    return new URL(url.substring(0, i) + "/WEB-INF/web.xml");
                }
            }
            catch (MalformedURLException e) {
                if (!this.log.isDebugEnabled()) break block8;
                this.log.debug((Object)"Failed to create URL instance!", (Throwable)e);
            }
        }
        return null;
    }
}

