/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.projectstage;

import javax.faces.application.ProjectStage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.seam.faces.projectstage.ProjectStageDetector;

public class JNDIProjectStageDetector
implements ProjectStageDetector {
    public int getPrecedence() {
        return 50;
    }

    public ProjectStage getProjectStage() {
        String projectStageName = this.getProjectStageNameFromJNDI();
        if (projectStageName != null && projectStageName.length() > 0) {
            for (ProjectStage stage : ProjectStage.values()) {
                if (!stage.name().equalsIgnoreCase(projectStageName)) continue;
                return stage;
            }
        }
        return null;
    }

    private String getProjectStageNameFromJNDI() {
        try {
            InitialContext context = new InitialContext();
            Object obj = context.lookup("java:comp/env/jsf/ProjectStage");
            if (obj != null) {
                return obj.toString().trim();
            }
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        return null;
    }
}

