/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.projectstage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.faces.application.ProjectStage;
import org.jboss.seam.faces.projectstage.Development;
import org.jboss.seam.faces.projectstage.Production;
import org.jboss.seam.faces.projectstage.ProjectStageDetector;
import org.jboss.seam.faces.projectstage.SystemTest;
import org.jboss.seam.faces.projectstage.UnitTest;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.util.Sortable;
import org.jboss.solder.util.service.ServiceLoader;

public class ProjectStageExtension
implements Extension {
    private final transient Logger log = Logger.getLogger(ProjectStageExtension.class);
    private static final ProjectStage DEFAULT_PROJECT_STAGE = ProjectStage.Production;
    private ProjectStage stage;

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        Set<ProjectStage> validProjectStages;
        if (this.stage == null) {
            this.stage = this.detectProjectStage();
        }
        if ((validProjectStages = this.getProjectStagesForType(pat.getAnnotatedType())).size() > 0 && !validProjectStages.contains(this.stage)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Preventing class " + pat.getAnnotatedType().getJavaClass().getName() + " from being installed due to the current project stage"));
            }
            pat.veto();
        }
    }

    private <T> Set<ProjectStage> getProjectStagesForType(AnnotatedType<T> type) {
        HashSet<ProjectStage> stages = new HashSet<ProjectStage>();
        if (type.getAnnotation(Development.class) != null) {
            stages.add(ProjectStage.Development);
        }
        if (type.getAnnotation(Production.class) != null) {
            stages.add(ProjectStage.Production);
        }
        if (type.getAnnotation(SystemTest.class) != null) {
            stages.add(ProjectStage.SystemTest);
        }
        if (type.getAnnotation(UnitTest.class) != null) {
            stages.add(ProjectStage.UnitTest);
        }
        return stages;
    }

    private ProjectStage detectProjectStage() {
        ArrayList detectors = new ArrayList();
        Iterator iter = ServiceLoader.load(ProjectStageDetector.class).iterator();
        while (iter.hasNext()) {
            detectors.add(iter.next());
        }
        Collections.sort(detectors, new Sortable.Comparator());
        for (ProjectStageDetector detector : detectors) {
            ProjectStage stage = detector.getProjectStage();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Detector " + detector.getClass().getName() + " returned: " + stage));
            }
            if (stage == null) continue;
            this.log.info((Object)("Detected project stage: " + stage));
            return stage;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("No result from detectors! Using default project stage: " + DEFAULT_PROJECT_STAGE));
        }
        return DEFAULT_PROJECT_STAGE;
    }
}

