/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.projectstage;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebXmlContextParameterParser
extends DefaultHandler {
    private final Stack<String> stack = new Stack();
    private final Map<String, String> entries = new HashMap<String, String>();
    private String currentName;
    private String currentValue;

    public final void parse(InputStream stream) throws IOException {
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setNamespaceAware(true);
            SAXParser parser = saxParserFactory.newSAXParser();
            parser.parse(stream, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    public String getContextParameter(String name) {
        return this.entries.get(name);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.stack.add(localName);
        if (this.elements("web-app", "context-param")) {
            this.currentName = null;
            this.currentValue = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.elements("web-app", "context-param", "param-name")) {
            this.currentName = String.valueOf(ch, start, length).trim();
        }
        if (this.elements("web-app", "context-param", "param-value")) {
            this.currentValue = String.valueOf(ch, start, length).trim();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String removedName;
        if (this.elements("web-app", "context-param") && this.currentName != null && this.currentValue != null) {
            this.entries.put(this.currentName, this.currentValue);
        }
        if (!(removedName = this.stack.pop()).equals(localName)) {
            throw new IllegalStateException("Found '" + removedName + "' but expected '" + localName + "' on the stack!");
        }
    }

    protected boolean elements(String ... name) {
        if (name == null || name.length != this.stack.size()) {
            return false;
        }
        for (int i = 0; i < name.length; ++i) {
            if (name[i].equals(this.stack.get(i))) continue;
            return false;
        }
        return true;
    }
}

