/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.projectstage;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.faces.application.ProjectStage;
import org.jboss.seam.faces.projectstage.ProjectStageDetector;
import org.jboss.seam.faces.projectstage.WebXmlContextParameterParser;
import org.jboss.seam.faces.projectstage.WebXmlLocator;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.util.Sortable;
import org.jboss.solder.util.service.ServiceLoader;

public class WebXmlProjectStageDetector
implements ProjectStageDetector {
    private final Logger log = Logger.getLogger(WebXmlProjectStageDetector.class);

    public int getPrecedence() {
        return 75;
    }

    public ProjectStage getProjectStage() {
        String projectStageName = this.getProjectStageFromLocators();
        if (projectStageName != null && projectStageName.length() > 0) {
            for (ProjectStage stage : ProjectStage.values()) {
                if (!stage.name().equalsIgnoreCase(projectStageName)) continue;
                return stage;
            }
        }
        return null;
    }

    private String getProjectStageFromLocators() {
        ArrayList locators = new ArrayList();
        Iterator iter = ServiceLoader.load(WebXmlLocator.class).iterator();
        while (iter.hasNext()) {
            locators.add(iter.next());
        }
        Collections.sort(locators, new Sortable.Comparator());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        for (WebXmlLocator locator : locators) {
            String projectStage;
            URL webXmlLocation = locator.getWebXmlLocation(classLoader);
            if (webXmlLocation == null || (projectStage = this.parseWebXml(webXmlLocation)) == null) continue;
            return projectStage;
        }
        return null;
    }

    private String parseWebXml(URL location) {
        block9: {
            InputStream webXmlStream;
            block8: {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Processing possible web.xml location: " + location));
                }
                webXmlStream = null;
                try {
                    webXmlStream = location.openStream();
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug((Object)("Unable to open web.xml: " + e.getMessage()));
                }
            }
            if (webXmlStream != null) {
                try {
                    WebXmlContextParameterParser parser = new WebXmlContextParameterParser();
                    parser.parse(webXmlStream);
                    String projectStage = parser.getContextParameter("javax.faces.PROJECT_STAGE");
                    if (projectStage != null) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Found project stage in web.xml: " + projectStage));
                        }
                        return projectStage;
                    }
                }
                catch (IOException e) {
                    if (!this.log.isDebugEnabled()) break block9;
                    this.log.debug((Object)("Parsing of web.xml failed: " + e.getMessage()));
                }
            }
        }
        return null;
    }
}

