/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.status;

import java.io.Serializable;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.faces.application.FacesMessage;
import javax.faces.event.PhaseEvent;
import javax.inject.Inject;
import org.jboss.seam.faces.context.RenderContext;
import org.jboss.seam.faces.event.PreNavigateEvent;
import org.jboss.seam.faces.event.qualifier.Before;
import org.jboss.seam.faces.event.qualifier.RenderResponse;
import org.jboss.seam.international.status.Level;
import org.jboss.seam.international.status.Message;
import org.jboss.seam.international.status.Messages;
import org.jboss.solder.logging.Logger;

public class MessagesAdapter
implements Serializable {
    private static final long serialVersionUID = -2908193057765795662L;
    private final transient Logger log = Logger.getLogger(MessagesAdapter.class);
    private static final String FLASH_MESSAGES_KEY = MessagesAdapter.class.getName() + ".FLASH_KEY";
    @Inject
    RenderContext context;

    void flushBeforeNavigate(@Observes PreNavigateEvent event, Messages messages) {
        if (!messages.getAll().isEmpty()) {
            this.log.debug((Object)"Saving status Messages to Flash Scope");
            this.context.put(FLASH_MESSAGES_KEY, (Object)messages.getAll());
            messages.clear();
        }
    }

    void convert(@Observes @Before @RenderResponse PhaseEvent event, Messages messages) {
        Set savedMessages = (Set)this.context.get(FLASH_MESSAGES_KEY);
        if (savedMessages != null) {
            for (Message m : savedMessages) {
                event.getFacesContext().addMessage(m.getTargets(), new FacesMessage(this.getSeverity(m.getLevel()), m.getText(), null));
            }
        }
        for (Message m : messages.getAll()) {
            event.getFacesContext().addMessage(m.getTargets(), new FacesMessage(this.getSeverity(m.getLevel()), m.getText(), null));
        }
        messages.clear();
    }

    private FacesMessage.Severity getSeverity(Level level) {
        FacesMessage.Severity result = FacesMessage.SEVERITY_INFO;
        switch (level) {
            case INFO: {
                break;
            }
            case WARN: {
                result = FacesMessage.SEVERITY_WARN;
                break;
            }
            case ERROR: {
                result = FacesMessage.SEVERITY_ERROR;
                break;
            }
            case FATAL: {
                result = FacesMessage.SEVERITY_FATAL;
                break;
            }
        }
        return result;
    }
}

