/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces.view.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.seam.faces.view.config.ViewConfig;
import org.jboss.seam.faces.view.config.ViewPattern;
import org.jboss.solder.logging.Logger;

public class ViewConfigExtension
implements Extension {
    private final transient Logger log = Logger.getLogger(ViewConfigExtension.class);
    private final Map<String, Set<Annotation>> data = new HashMap<String, Set<Annotation>>();

    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event) {
        AnnotatedType tp = event.getAnnotatedType();
        if (this.log.isTraceEnabled()) {
            this.log.tracef("Annotated Type: %s", (Object)tp.getJavaClass().getName());
            for (Annotation annotation : tp.getAnnotations()) {
                this.log.tracef("|-- Annotation: %s", (Object)annotation.annotationType().getName());
                for (Annotation qualifier : annotation.getClass().getAnnotations()) {
                    this.log.tracef("    |-- Qualifier: %s", (Object)qualifier.annotationType().getName());
                }
            }
        }
        if (tp.isAnnotationPresent(ViewConfig.class)) {
            if (!tp.getJavaClass().isInterface()) {
                this.log.warn((Object)("ViewConfig annotation should only be applied to interfaces, and [" + tp.getJavaClass() + "] is not an interface."));
            } else {
                boolean securityNotFound = false;
                try {
                    this.getClass().getClassLoader().loadClass("org.jboss.seam.security.SecurityExtension");
                }
                catch (ClassNotFoundException e) {
                    securityNotFound = true;
                    this.log.debug((Object)"Security not found");
                }
                for (Class<?> clazz : tp.getJavaClass().getClasses()) {
                    for (Field enumm : clazz.getFields()) {
                        if (!enumm.isAnnotationPresent(ViewPattern.class)) continue;
                        ViewPattern viewConfig = enumm.getAnnotation(ViewPattern.class);
                        HashSet<Annotation> viewPattern = new HashSet<Annotation>();
                        this.data.put(viewConfig.value(), viewPattern);
                        for (Annotation a : enumm.getAnnotations()) {
                            if (a.annotationType() != ViewPattern.class) {
                                viewPattern.add(a);
                            }
                            if (!securityNotFound) continue;
                            this.log.tracef("Checking annotations on annotation %s for use of SecurityBindingType", (Object)a.annotationType().getSimpleName());
                            for (Annotation annotation : a.annotationType().getAnnotations()) {
                                this.log.tracef("Checking annotation %s", (Object)annotation.annotationType().getName());
                                if (!"SecurityBindingType".equals(annotation.annotationType().getSimpleName())) continue;
                                throw new RuntimeException("Security annotation found without Seam Security present");
                            }
                        }
                    }
                }
            }
        }
    }

    public Map<String, Set<Annotation>> getData() {
        return Collections.unmodifiableMap(this.data);
    }
}

