/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.datetimezone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.jboss.seam.international.datetimezone.ForwardingDateTimeZone;
import org.joda.time.DateTimeZone;

@ApplicationScoped
public class AvailableDateTimeZones {
    private static final String TIMEZONE_ID_PREFIXES = "^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*";
    @Produces
    private List<ForwardingDateTimeZone> dateTimeZones = null;

    @PostConstruct
    public void init() {
        this.dateTimeZones = new ArrayList<ForwardingDateTimeZone>();
        Set timeZoneIds = DateTimeZone.getAvailableIDs();
        for (Object object : timeZoneIds) {
            String id = (String)object;
            if (!id.matches(TIMEZONE_ID_PREFIXES)) continue;
            final DateTimeZone dtz = DateTimeZone.forID((String)id);
            this.dateTimeZones.add(new ForwardingDateTimeZone(id){

                @Override
                protected DateTimeZone delegate() {
                    return dtz;
                }
            });
        }
        Collections.sort(this.dateTimeZones, new Comparator<ForwardingDateTimeZone>(){

            @Override
            public int compare(ForwardingDateTimeZone a, ForwardingDateTimeZone b) {
                return a.getID().compareTo(b.getID());
            }
        });
        this.dateTimeZones = Collections.unmodifiableList(this.dateTimeZones);
    }
}

