/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.locale;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.international.locale.LocaleUtils;
import org.jboss.seam.international.locale.SupportedLocaleKeys;

@ApplicationScoped
public class AvailableLocales {
    private final Logger log = Logger.getLogger(AvailableLocales.class);
    @Inject
    @SupportedLocaleKeys
    private Instance<List<String>> supportedLocaleKeys;
    @Produces
    private List<Locale> locales = null;

    @PostConstruct
    public void init() {
        this.locales = new ArrayList<Locale>();
        if (!this.supportedLocaleKeys.isUnsatisfied()) {
            List keys = (List)this.supportedLocaleKeys.get();
            for (String localeKey : keys) {
                try {
                    Locale lc = LocaleUtils.toLocale(localeKey);
                    this.locales.add(lc);
                }
                catch (IllegalArgumentException e) {
                    this.log.error((Object)("AvailableLocales: Supported Locale key of " + localeKey + " was not formatted correctly"), (Throwable)e);
                }
            }
        }
        Collections.sort(this.locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale a, Locale b) {
                return a.toString().compareTo(b.toString());
            }
        });
        this.locales = Collections.unmodifiableList(this.locales);
    }
}

