/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.international.jdktimezone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimeZone;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import org.jboss.seam.international.jdktimezone.ForwardingTimeZone;

@ApplicationScoped
public class AvailableTimeZones {
    private static final String TIMEZONE_ID_PREFIXES = "^(Africa|America|Asia|Atlantic|Australia|Europe|Indian|Pacific)/.*";
    @Produces
    private List<ForwardingTimeZone> timeZones = null;

    @PostConstruct
    public void init() {
        String[] timeZoneIds;
        this.timeZones = new ArrayList<ForwardingTimeZone>();
        for (String id : timeZoneIds = TimeZone.getAvailableIDs()) {
            if (!id.matches(TIMEZONE_ID_PREFIXES)) continue;
            final TimeZone dtz = TimeZone.getTimeZone(id);
            this.timeZones.add(new ForwardingTimeZone(id){
                private static final long serialVersionUID = 8409832600089507805L;

                @Override
                protected TimeZone delegate() {
                    return dtz;
                }

                @Override
                public void setRawOffset(int offsetMillis) {
                    throw new UnsupportedOperationException();
                }
            });
        }
        Collections.sort(this.timeZones, new Comparator<ForwardingTimeZone>(){

            @Override
            public int compare(ForwardingTimeZone a, ForwardingTimeZone b) {
                return a.getID().compareTo(b.getID());
            }
        });
        this.timeZones = Collections.unmodifiableList(this.timeZones);
    }
}

